/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzmd;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzff
implements zzfe {
    private final Context mContext;
    private final VersionInfoParcel zzanu;

    public zzff(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzanu = versionInfoParcel;
    }

    protected zzb zzb(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzkx.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zznc());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zznh()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzkx.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zznd().openConnection();
            zzu.zzgm().zza(this.mContext, this.zzanu.zzda, false, httpURLConnection);
            for (zza object22 : zzb2.zzne()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zznf())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zznf().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zznc(), httpURLConnection.getResponseCode(), (List<zza>)object, zzu.zzgm().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzbc(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzkx.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzb(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzng());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzmd zzmd2, final Map<String, String> map) {
        zzla.zza(new Runnable(){

            @Override
            public void run() {
                zzkx.zzdg((String)"Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzff.this.zzbc(string2);
                if (jSONObject == null) {
                    zzkx.e((String)"Response should not be null.");
                    return;
                }
                zzlb.zzcvl.post(new Runnable(){

                    @Override
                    public void run() {
                        zzmd2.zzb("fetchHttpRequestCompleted", jSONObject);
                        zzkx.zzdg((String)"Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzji
    class zzc {
        private final zzd zzbqm;
        private final boolean zzbqn;
        private final String zzbqo;

        public zzc(boolean bl, zzd zzd2, String string2) {
            this.zzbqn = bl;
            this.zzbqm = zzd2;
            this.zzbqo = string2;
        }

        public String getReason() {
            return this.zzbqo;
        }

        public zzd zzng() {
            return this.zzbqm;
        }

        public boolean isSuccess() {
            return this.zzbqn;
        }
    }

    @zzji
    static class zzd {
        private final String zzbqi;
        private final int zzbqp;
        private final List<zza> zzbqq;
        private final String zzbna;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzbqi = string2;
            this.zzbqp = n;
            this.zzbqq = list == null ? new ArrayList<zza>() : list;
            this.zzbna = string3;
        }

        public String zznc() {
            return this.zzbqi;
        }

        public int getResponseCode() {
            return this.zzbqp;
        }

        public Iterable<zza> zznh() {
            return this.zzbqq;
        }

        public String getBody() {
            return this.zzbna;
        }
    }

    @zzji
    static class zzb {
        private final String zzbqi;
        private final URL zzbqj;
        private final ArrayList<zza> zzbqk;
        private final String zzbql;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzbqi = string2;
            this.zzbqj = uRL;
            this.zzbqk = arrayList == null ? new ArrayList() : arrayList;
            this.zzbql = string3;
        }

        public String zznc() {
            return this.zzbqi;
        }

        public URL zznd() {
            return this.zzbqj;
        }

        public ArrayList<zza> zzne() {
            return this.zzbqk;
        }

        public String zznf() {
            return this.zzbql;
        }
    }

    @zzji
    static class zza {
        private final String zzbcn;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzbcn = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zzbcn;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

