/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzmd;
import java.util.Map;
import org.json.JSONObject;

@zzji
public final class zzfo
implements zzfe {
    private boolean zzbqz;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzm.zzkr().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzkx.zzdi((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzmd zzmd2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzkx.zzdi((String)"Action missing from video GMSG.");
            return;
        }
        if (zzkx.zzbi((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzkx.zzdg((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzkx.zzdi((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object);
                zzmd2.setBackgroundColor(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkx.zzdi((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzmd2.zzxk();
        if (object == null) {
            zzkx.zzdi((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzmd2.getContext();
            int n2 = zzfo.zza(context, map, "x", 0);
            int n3 = zzfo.zza(context, map, "y", 0);
            int n4 = zzfo.zza(context, map, "w", -1);
            int n5 = zzfo.zza(context, map, "h", -1);
            if (zzdr.zzbjh.get().booleanValue()) {
                n4 = Math.min(n4, zzmd2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzmd2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzmc)object).zzwv() == null) {
                ((zzmc)object).zza(n2, n3, n4, n5, n, bl3);
            } else {
                ((zzmc)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk2 = ((zzmc)object).zzwv();
            if (zzk2 == null) {
                zzk.zzi(zzmd2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzmd2.getContext();
                int n = zzfo.zza(context, map, "x", 0);
                int n6 = zzfo.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
                zzk2.zzf(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzkx.zzdi((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzk2.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzkx.zzdi((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzk2.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk2.zznt();
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzk2.zzqh();
                } else {
                    zzk2.zzqi();
                }
            } else if ("pause".equals(string2)) {
                zzk2.pause();
            } else if ("play".equals(string2)) {
                zzk2.play();
            } else if ("show".equals(string2)) {
                zzk2.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk2.zzce(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzmd2.getContext();
                int n = zzfo.zza(context, map, "dx", 0);
                int n7 = zzfo.zza(context, map, "dy", 0);
                zzk2.zza(n, n7);
                if (!this.zzbqz) {
                    zzd zzd2 = zzmd2.zzxa();
                    zzd2.zzpt();
                    this.zzbqz = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzkx.zzdi((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzk2.zzb(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzkx.zzdi((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzk2.zzqj();
            } else {
                String string8 = String.valueOf(string2);
                zzkx.zzdi((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

