/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.zza;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzmd;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

@zzji
public abstract class zzfs
implements Releasable {
    protected Context mContext;
    protected String zzbre;
    protected WeakReference<zzmd> zzbrf;

    public zzfs(zzmd zzmd2) {
        this.mContext = zzmd2.getContext();
        this.zzbre = zzu.zzgm().zzh(this.mContext, zzmd2.zzxf().zzda);
        this.zzbrf = new WeakReference<zzmd>(zzmd2);
    }

    public abstract boolean zzbg(String var1);

    public abstract void abort();

    public void release() {
    }

    protected void zza(final String string2, final String string3, final int n, final int n2, final boolean bl) {
        zza.zzcxr.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheProgress");
                hashMap.put("src", string2);
                hashMap.put("cachedSrc", string3);
                hashMap.put("bytesLoaded", Integer.toString(n));
                hashMap.put("totalBytes", Integer.toString(n2));
                hashMap.put("cacheReady", bl ? "1" : "0");
                zzfs.this.zza("onPrecacheEvent", hashMap);
            }
        });
    }

    protected void zza(final String string2, final String string3, final int n) {
        zza.zzcxr.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheComplete");
                hashMap.put("src", string2);
                hashMap.put("cachedSrc", string3);
                hashMap.put("totalBytes", Integer.toString(n));
                zzfs.this.zza("onPrecacheEvent", hashMap);
            }
        });
    }

    public void zza(final String string2, final String string3, final String string4, final @Nullable String string5) {
        zza.zzcxr.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheCanceled");
                hashMap.put("src", string2);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    hashMap.put("cachedSrc", string3);
                }
                hashMap.put("type", zzfs.this.zzbi(string4));
                hashMap.put("reason", string4);
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    hashMap.put("message", string5);
                }
                zzfs.this.zza("onPrecacheEvent", hashMap);
            }
        });
    }

    protected String zzbh(String string2) {
        return zzm.zzkr().zzdf(string2);
    }

    private String zzbi(String string2) {
        String string3 = "internal";
        switch (string2) {
            case "error": 
            case "playerFailed": 
            case "inProgress": 
            case "contentLengthMissing": {
                string3 = "internal";
                break;
            }
            case "noCacheDir": 
            case "expireFailed": {
                string3 = "io";
                break;
            }
            case "badUrl": 
            case "downloadTimeout": {
                string3 = "network";
                break;
            }
            case "sizeExceeded": 
            case "externalAbort": {
                string3 = "policy";
            }
        }
        return string3;
    }

    private void zza(String string2, Map<String, String> map) {
        zzmd zzmd2 = (zzmd)this.zzbrf.get();
        if (zzmd2 != null) {
            zzmd2.zza(string2, map);
        }
    }
}

