/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzgt
implements zzgu.zza {
    private final String zzbwa;
    private final zzgz zzamf;
    private final long zzbwb;
    private final zzgq zzbwc;
    private final zzgp zzbwd;
    private AdRequestParcel zzapj;
    private final AdSizeParcel zzapp;
    private final Context mContext;
    private final Object zzako = new Object();
    private final VersionInfoParcel zzanu;
    private final boolean zzasz;
    private final NativeAdOptionsParcel zzanq;
    private final List<String> zzanr;
    private final boolean zzbwe;
    private zzha zzbwf;
    private int zzbwg = -2;
    private zzhc zzbwh;

    public zzgt(Context context, String string2, zzgz zzgz2, zzgq zzgq2, zzgp zzgp2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, boolean bl2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzamf = zzgz2;
        this.zzbwd = zzgp2;
        this.zzbwa = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzof() : string2;
        this.zzbwc = zzgq2;
        this.zzbwb = zzgq2.zzbvj != -1L ? zzgq2.zzbvj : 10000L;
        this.zzapj = adRequestParcel;
        this.zzapp = adSizeParcel;
        this.zzanu = versionInfoParcel;
        this.zzasz = bl;
        this.zzbwe = bl2;
        this.zzanq = nativeAdOptionsParcel;
        this.zzanr = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzako;
        synchronized (object) {
            try {
                if (this.zzbwf != null) {
                    this.zzbwf.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzbwg = -1;
            this.zzako.notify();
        }
    }

    private String zzof() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzbwd.zzbuw)) {
                return this.zzamf.zzbv(this.zzbwd.zzbuw) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzkx.zzdi((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzad(int n) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzbwg = n;
            this.zzako.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzhc zzhc2) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzbwg = n;
            this.zzbwh = zzhc2;
            this.zzako.notify();
        }
    }

    protected zzha zza(MediationAdapter mediationAdapter) {
        return new zzhg(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzgu zza(long l, long l2) {
        Object object = this.zzako;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzgs zzgs2 = new zzgs();
            zzlb.zzcvl.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzgt.this.zzako;
                    synchronized (object) {
                        if (zzgt.this.zzbwg != -2) {
                            return;
                        }
                        zzgt.this.zzbwf = zzgt.this.zzoh();
                        if (zzgt.this.zzbwf == null) {
                            zzgt.this.zzad(4);
                            return;
                        }
                        if (zzgt.this.zzoi() && !zzgt.this.zzae(1)) {
                            String string2 = zzgt.this.zzbwa;
                            zzkx.zzdi((String)new StringBuilder(56 + String.valueOf(string2).length()).append("Ignoring adapter ").append(string2).append(" as delayed impression is not supported").toString());
                            zzgt.this.zzad(2);
                            return;
                        }
                        zzgs2.zza(zzgt.this);
                        zzgt.this.zza(zzgs2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzbwb, l, l2);
            return new zzgu(this.zzbwd, this.zzbwf, this.zzbwa, zzgs2, this.zzbwg, this.zzog(), l4);
        }
    }

    private zzhc zzog() {
        if (this.zzbwg != 0 || !this.zzoi()) {
            return null;
        }
        try {
            if (this.zzae(4) && this.zzbwh != null && this.zzbwh.zzok() != 0) {
                return this.zzbwh;
            }
        }
        catch (RemoteException remoteException) {
            zzkx.zzdi((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzgt.zzaf(this.zzoj());
    }

    private zzha zzoh() {
        String string2 = String.valueOf(this.zzbwa);
        zzkx.zzdh((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzasz) {
            if (zzdr.zzbhh.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbwa)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzdr.zzbhi.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzbwa)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzbwa)) {
                return new zzhg((MediationAdapter)new zzho());
            }
        }
        try {
            return this.zzamf.zzbu(this.zzbwa);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzbwa);
            zzkx.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzgs zzgs2) {
        String string2 = this.zzbr(this.zzbwd.zzbva);
        try {
            if (this.zzanu.zzcyb < 4100000) {
                if (this.zzapp.zzazr) {
                    this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapj, string2, (zzhb)zzgs2);
                } else {
                    this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapp, this.zzapj, string2, (zzhb)zzgs2);
                }
            } else if (this.zzasz) {
                this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapj, string2, this.zzbwd.zzbus, (zzhb)zzgs2, this.zzanq, this.zzanr);
            } else if (this.zzapp.zzazr) {
                this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapj, string2, this.zzbwd.zzbus, (zzhb)zzgs2);
            } else if (this.zzbwe) {
                if (this.zzbwd.zzbvd != null) {
                    this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapj, string2, this.zzbwd.zzbus, (zzhb)zzgs2, new NativeAdOptionsParcel(zzgt.zzbs(this.zzbwd.zzbvh)), this.zzbwd.zzbvg);
                } else {
                    this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapp, this.zzapj, string2, this.zzbwd.zzbus, (zzhb)zzgs2);
                }
            } else {
                this.zzbwf.zza(zze.zzac((Object)this.mContext), this.zzapp, this.zzapj, string2, this.zzbwd.zzbus, (zzhb)zzgs2);
            }
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzad(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzbwg == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzu.zzgs().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzkx.zzdh((String)"Timed out waiting for adapter.");
            this.zzbwg = 3;
            return;
        }
        try {
            this.zzako.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzbwg = -1;
        }
    }

    private boolean zzae(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zzasz ? this.zzbwf.zzop() : (this.zzapp.zzazr ? this.zzbwf.getInterstitialAdapterInfo() : this.zzbwf.zzoo());
        }
        catch (RemoteException remoteException) {
            zzkx.zzdi((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzoi() {
        return this.zzbwc.zzbvt != -1;
    }

    private String zzbr(String string2) {
        if (string2 == null || !this.zzoi() || this.zzae(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzkx.zzdi((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    private int zzoj() {
        JSONObject jSONObject;
        if (this.zzbwd.zzbva == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzbwd.zzbva);
        }
        catch (JSONException jSONException) {
            zzkx.zzdi((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbwa)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzae(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzhc zzaf(final int n) {
        return new zzhc.zza(){

            public int zzok() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzbs(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzgt.zzbt(string3));
        }
        catch (JSONException jSONException) {
            zzkx.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzbt(String string2) {
        if ("landscape".equals(string2)) {
            return 2;
        }
        if ("portrait".equals(string2)) {
            return 1;
        }
        return 0;
    }
}

