/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzmd;
import java.util.Map;
import java.util.Set;

@zzji
public class zzhq
extends zzhv {
    static final Set<String> zzbyd = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzbye = "top-right";
    private boolean zzbyf = true;
    private int zzbyg = 0;
    private int zzbyh = 0;
    private int zzaki = -1;
    private int zzbyi = 0;
    private int zzbyj = 0;
    private int zzakh = -1;
    private final Object zzako = new Object();
    private final zzmd zzbnz;
    private final Activity zzbxt;
    private AdSizeParcel zzapp;
    private ImageView zzbyk;
    private LinearLayout zzbyl;
    private zzhw zzbym;
    private PopupWindow zzbyn;
    private RelativeLayout zzbyo;
    private ViewGroup zzbyp;

    public zzhq(zzmd zzmd2, zzhw zzhw2) {
        super(zzmd2, "resize");
        this.zzbnz = zzmd2;
        this.zzbxt = zzmd2.zzwy();
        this.zzbym = zzhw2;
    }

    private void zzj(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzakh = zzu.zzgm().zzda(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzaki = zzu.zzgm().zzda(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzbyi = zzu.zzgm().zzda(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzbyj = zzu.zzgm().zzda(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzbyf = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzbye = string2;
        }
    }

    boolean zzos() {
        return this.zzakh > -1 && this.zzaki > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzako;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzbxt == null) {
                this.zzcb("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbnz.zzeg() == null) {
                this.zzcb("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbnz.zzeg().zzazr) {
                this.zzcb("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbnz.zzxg()) {
                this.zzcb("Cannot resize an expanded banner.");
                return;
            }
            this.zzj(map);
            if (!this.zzos()) {
                this.zzcb("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzbxt.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzcb("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzot();
            if (nArray == null) {
                this.zzcb("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzm.zzkr().zzb((Context)this.zzbxt, this.zzakh);
            int n2 = zzm.zzkr().zzb((Context)this.zzbxt, this.zzaki);
            ViewParent viewParent = this.zzbnz.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzbnz.getView());
                if (this.zzbyn == null) {
                    this.zzbyp = (ViewGroup)viewParent;
                    bitmap = zzu.zzgm().zzq(this.zzbnz.getView());
                    this.zzbyk = new ImageView((Context)this.zzbxt);
                    this.zzbyk.setImageBitmap(bitmap);
                    this.zzapp = this.zzbnz.zzeg();
                    this.zzbyp.addView((View)this.zzbyk);
                } else {
                    this.zzbyn.dismiss();
                }
            } else {
                this.zzcb("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzbyo = new RelativeLayout((Context)this.zzbxt);
            this.zzbyo.setBackgroundColor(0);
            this.zzbyo.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzbyn = zzu.zzgm().zza((View)this.zzbyo, n, n2, false);
            this.zzbyn.setOutsideTouchable(true);
            this.zzbyn.setTouchable(true);
            this.zzbyn.setClippingEnabled(!this.zzbyf);
            this.zzbyo.addView(this.zzbnz.getView(), -1, -1);
            this.zzbyl = new LinearLayout((Context)this.zzbxt);
            bitmap = new RelativeLayout.LayoutParams(zzm.zzkr().zzb((Context)this.zzbxt, 50), zzm.zzkr().zzb((Context)this.zzbxt, 50));
            switch (this.zzbye) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzbyl.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzhq.this.zzt(true);
                }
            });
            this.zzbyl.setContentDescription((CharSequence)"Close button");
            this.zzbyo.addView((View)this.zzbyl, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzbyn.showAtLocation(window.getDecorView(), 0, zzm.zzkr().zzb((Context)this.zzbxt, nArray[0]), zzm.zzkr().zzb((Context)this.zzbxt, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzcb(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzbyo.removeView(this.zzbnz.getView());
                if (this.zzbyp != null) {
                    this.zzbyp.removeView((View)this.zzbyk);
                    this.zzbyp.addView(this.zzbnz.getView());
                    this.zzbnz.zza(this.zzapp);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzbnz.zza(new AdSizeParcel((Context)this.zzbxt, new AdSize(this.zzakh, this.zzaki)));
            this.zzc(nArray[0], nArray[1]);
            this.zzcd("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzt(boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzbyn != null) {
                this.zzbyn.dismiss();
                this.zzbyo.removeView(this.zzbnz.getView());
                if (this.zzbyp != null) {
                    this.zzbyp.removeView((View)this.zzbyk);
                    this.zzbyp.addView(this.zzbnz.getView());
                    this.zzbnz.zza(this.zzapp);
                }
                if (bl) {
                    this.zzcd("default");
                    if (this.zzbym != null) {
                        this.zzbym.zzfc();
                    }
                }
                this.zzbyn = null;
                this.zzbyo = null;
                this.zzbyp = null;
                this.zzbyl = null;
            }
        }
    }

    private int[] zzot() {
        if (!this.zzov()) {
            return null;
        }
        if (this.zzbyf) {
            return new int[]{this.zzbyg + this.zzbyi, this.zzbyh + this.zzbyj};
        }
        int[] nArray = zzu.zzgm().zzi(this.zzbxt);
        int[] nArray2 = zzu.zzgm().zzk(this.zzbxt);
        int n = nArray[0];
        int n2 = this.zzbyg + this.zzbyi;
        int n3 = this.zzbyh + this.zzbyj;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzakh > n) {
            n2 = n - this.zzakh;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzaki > nArray2[1]) {
            n3 = nArray2[1] - this.zzaki;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzbyg = n;
            this.zzbyh = n2;
            if (this.zzbyn != null && bl) {
                int[] nArray = this.zzot();
                if (nArray != null) {
                    this.zzbyn.update(zzm.zzkr().zzb((Context)this.zzbxt, nArray[0]), zzm.zzkr().zzb((Context)this.zzbxt, nArray[1]), this.zzbyn.getWidth(), this.zzbyn.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzt(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzbym != null) {
            this.zzbym.zza(n, n2, this.zzakh, this.zzaki);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzu.zzgm().zzk(this.zzbxt)[0];
        this.zzb(n, n2 - n3, this.zzakh, this.zzaki);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzou() {
        Object object = this.zzako;
        synchronized (object) {
            return this.zzbyn != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzbyg = n;
        this.zzbyh = n2;
    }

    boolean zzov() {
        int[] nArray = zzu.zzgm().zzi(this.zzbxt);
        int[] nArray2 = zzu.zzgm().zzk(this.zzbxt);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzakh < 50 || this.zzakh > n) {
            zzkx.zzdi((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzaki < 50 || this.zzaki > n2) {
            zzkx.zzdi((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzaki == n2 && this.zzakh == n) {
            zzkx.zzdi((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzbyf) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzbye) {
                case "top-left": {
                    n3 = this.zzbyg + this.zzbyi;
                    n4 = this.zzbyh + this.zzbyj;
                    break;
                }
                case "top-center": {
                    n3 = this.zzbyg + this.zzbyi + this.zzakh / 2 - 25;
                    n4 = this.zzbyh + this.zzbyj;
                    break;
                }
                case "center": {
                    n3 = this.zzbyg + this.zzbyi + this.zzakh / 2 - 25;
                    n4 = this.zzbyh + this.zzbyj + this.zzaki / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzbyg + this.zzbyi;
                    n4 = this.zzbyh + this.zzbyj + this.zzaki - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzbyg + this.zzbyi + this.zzakh / 2 - 25;
                    n4 = this.zzbyh + this.zzbyj + this.zzaki - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzbyg + this.zzbyi + this.zzakh - 50;
                    n4 = this.zzbyh + this.zzbyj + this.zzaki - 50;
                    break;
                }
                default: {
                    n3 = this.zzbyg + this.zzbyi + this.zzakh - 50;
                    n4 = this.zzbyh + this.zzbyj;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

