/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzmd;
import java.util.Map;

@zzji
public class zzhs
extends zzhv {
    private final Map<String, String> zzbly;
    private final Context mContext;

    public zzhs(zzmd zzmd2, Map<String, String> map) {
        super(zzmd2, "storePicture");
        this.zzbly = map;
        this.mContext = zzmd2.zzwy();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzcb("Activity context is not available");
            return;
        }
        zzdj zzdj2 = zzu.zzgm().zzac(this.mContext);
        if (!zzdj2.zzll()) {
            this.zzcb("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzbly.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzcb("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzcb(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzca(string2);
        if (!zzu.zzgm().zzdb(string4)) {
            String string5 = String.valueOf(string4);
            this.zzcb(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzu.zzgq().getResources();
        AlertDialog.Builder builder = zzu.zzgm().zzab(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                DownloadManager downloadManager = (DownloadManager)zzhs.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzhs.this.zzj(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzhs.this.zzcb("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzhs.this.zzcb("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzj(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzu.zzgo().zza(request);
        return request;
    }

    String zzca(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

