/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.AutoClickProtectionConfigurationParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.safebrowsing.SafeBrowsingConfigParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzkv;
import com.google.android.gms.internal.zzkx;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public final class zzjm {
    private static final SimpleDateFormat zzcny = new SimpleDateFormat("yyyyMMdd", Locale.US);

    @Nullable
    public static JSONObject zza(Context context, zzjj zzjj2) {
        AdRequestInfoParcel adRequestInfoParcel = zzjj2.zzcmx;
        Location location = zzjj2.zzayt;
        zzjr zzjr2 = zzjj2.zzcmy;
        Bundle bundle = zzjj2.zzckb;
        JSONObject jSONObject = zzjj2.zzcmz;
        try {
            boolean bl;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("extra_caps", zzdr.zzbit.get());
            if (zzjj2.zzckj.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", zzjj2.zzckj));
            }
            if (adRequestInfoParcel.zzcjt != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzcjt);
            }
            zzjm.zza(hashMap, adRequestInfoParcel.zzcju);
            if (adRequestInfoParcel.zzarm.zzazs == null) {
                hashMap.put("format", adRequestInfoParcel.zzarm.zzazq);
                if (adRequestInfoParcel.zzarm.zzazu) {
                    hashMap.put("fluid", "height");
                }
            } else {
                boolean bl2 = false;
                bl = false;
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzarm.zzazs) {
                    if (!adSizeParcel.zzazu && !bl2) {
                        hashMap.put("format", adSizeParcel.zzazq);
                        bl2 = true;
                    }
                    if (adSizeParcel.zzazu && !bl) {
                        hashMap.put("fluid", "height");
                        bl = true;
                    }
                    if (bl2 && bl) break;
                }
            }
            if (adRequestInfoParcel.zzarm.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzarm.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzarm.zzazs != null) {
                StringBuilder stringBuilder = new StringBuilder();
                bl = false;
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzarm.zzazs) {
                    if (adSizeParcel.zzazu) {
                        bl = true;
                        continue;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzjr2.zzavd) : adSizeParcel.width);
                    stringBuilder.append("x");
                    stringBuilder.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzjr2.zzavd) : adSizeParcel.height);
                }
                if (bl) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.insert(0, "|");
                    }
                    stringBuilder.insert(0, "320x50");
                }
                hashMap.put("sz", stringBuilder);
            }
            if (adRequestInfoParcel.zzcka != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzcka);
                hashMap.put("native_templates", adRequestInfoParcel.zzase);
                hashMap.put("native_image_orientation", zzjm.zzc(adRequestInfoParcel.zzasa));
                if (!adRequestInfoParcel.zzckk.isEmpty()) {
                    hashMap.put("native_custom_templates", adRequestInfoParcel.zzckk);
                }
            }
            if (adRequestInfoParcel.zzarm.zzazv) {
                hashMap.put("ene", true);
            }
            hashMap.put("slotname", adRequestInfoParcel.zzarg);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzcjv != null) {
                hashMap.put("vc", adRequestInfoParcel.zzcjv.versionCode);
            }
            hashMap.put("ms", zzjj2.zzcjw);
            hashMap.put("seq_num", adRequestInfoParcel.zzcjx);
            hashMap.put("session_id", adRequestInfoParcel.zzcjy);
            hashMap.put("js", adRequestInfoParcel.zzari.zzda);
            zzjm.zza(hashMap, zzjr2, zzjj2.zzcmv, adRequestInfoParcel.zzckx, zzjj2.zzcmu);
            zzjm.zza(hashMap, zzjj2.zzcmw);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zzjm.zza(hashMap, location);
            } else if (adRequestInfoParcel.zzcju.versionCode >= 2 && adRequestInfoParcel.zzcju.zzayt != null) {
                zzjm.zza(hashMap, adRequestInfoParcel.zzcju.zzayt);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzcjz);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzckc) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzckc);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzavd));
                hashMap.put("sh", adRequestInfoParcel.zzckf);
                hashMap.put("sw", adRequestInfoParcel.zzcke);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzjr2.zzavd));
                hashMap.put("sh", zzjr2.zzckf);
                hashMap.put("sw", zzjr2.zzcke);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzckg)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzckg));
                    }
                    catch (JSONException jSONException) {
                        zzkx.zzc((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzckh);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzcki);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzckm != null) {
                hashMap.put("capability", adRequestInfoParcel.zzckm.toBundle());
            }
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzckn)) {
                hashMap.put("anchor", adRequestInfoParcel.zzckn);
            }
            if (adRequestInfoParcel.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(adRequestInfoParcel.zzcko));
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_app_muted", adRequestInfoParcel.zzcku);
            }
            if (adRequestInfoParcel.versionCode >= 14 && adRequestInfoParcel.zzckp > 0) {
                hashMap.put("target_api", adRequestInfoParcel.zzckp);
            }
            if (adRequestInfoParcel.versionCode >= 15) {
                hashMap.put("scroll_index", adRequestInfoParcel.zzckq == -1 ? -1 : adRequestInfoParcel.zzckq);
            }
            if (adRequestInfoParcel.versionCode >= 16) {
                hashMap.put("_activity_context", adRequestInfoParcel.zzckr);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzckv)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(adRequestInfoParcel.zzckv));
                    }
                    catch (JSONException jSONException) {
                        zzkx.zzc((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", adRequestInfoParcel.zzbvo);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", adRequestInfoParcel.zzckw);
            }
            zzjm.zza(hashMap);
            hashMap.put("cache_state", jSONObject);
            if (adRequestInfoParcel.versionCode >= 19) {
                hashMap.put("gct", adRequestInfoParcel.zzcky);
            }
            if (zzkx.zzbi((int)2)) {
                String string2 = zzu.zzgm().zzap(hashMap).toString(2);
                String string3 = String.valueOf(string2);
                zzkx.v(string3.length() != 0 ? "Ad Request JSON: ".concat(string3) : new String("Ad Request JSON: "));
            }
            return zzu.zzgm().zzap(hashMap);
        }
        catch (JSONException jSONException) {
            String string4 = String.valueOf(jSONException.getMessage());
            zzkx.zzdi((String)(string4.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string4) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap) {
        Bundle bundle = new Bundle();
        Bundle bundle2 = new Bundle();
        bundle2.putString("cl", "135396225");
        bundle2.putString("rapid_rc", "dev");
        bundle2.putString("rapid_rollup", "HEAD");
        bundle.putBundle("build_meta", bundle2);
        bundle.putString("mf", Boolean.toString(zzdr.zzbiv.get()));
        hashMap.put("sdk_env", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", string2);
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzkv.zzvl();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzayl != -1L) {
            hashMap.put("cust_age", zzcny.format(new Date(adRequestParcel.zzayl)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzaym != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzaym);
        }
        if (adRequestParcel.zzayn != null) {
            hashMap.put("kw", adRequestParcel.zzayn);
        }
        if (adRequestParcel.zzayp != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzayp);
        }
        if (adRequestParcel.zzayo) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzayq) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzayr)) {
                hashMap.put("ppid", adRequestParcel.zzayr);
            }
            if (adRequestParcel.zzays != null) {
                zzjm.zza(hashMap, adRequestParcel.zzays);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzayu != null) {
            hashMap.put("url", adRequestParcel.zzayu);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzayw != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzayw);
            }
            if (adRequestParcel.zzayx != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzayx);
            }
            if (adRequestParcel.zzayy != null) {
                hashMap.put("request_agent", adRequestParcel.zzayy);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzayz != null) {
            hashMap.put("request_pkg", adRequestParcel.zzayz);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zzaza);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzjr zzjr2, zzjv.zza zza2, Bundle bundle, Bundle bundle2) {
        Bundle bundle3;
        hashMap.put("am", zzjr2.zzcps);
        hashMap.put("cog", zzjm.zzac(zzjr2.zzcpt));
        hashMap.put("coh", zzjm.zzac(zzjr2.zzcpu));
        if (!TextUtils.isEmpty((CharSequence)zzjr2.zzcpv)) {
            hashMap.put("carrier", zzjr2.zzcpv);
        }
        hashMap.put("gl", zzjr2.zzcpw);
        if (zzjr2.zzcpx) {
            hashMap.put("simulator", 1);
        }
        if (zzjr2.zzcpy) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzjm.zzac(zzjr2.zzcpz));
        hashMap.put("sp", zzjm.zzac(zzjr2.zzcqa));
        hashMap.put("hl", zzjr2.zzcqb);
        if (!TextUtils.isEmpty((CharSequence)zzjr2.zzcqc)) {
            hashMap.put("mv", zzjr2.zzcqc);
        }
        hashMap.put("muv", zzjr2.zzcqd);
        if (zzjr2.zzcqe != -2) {
            hashMap.put("cnt", zzjr2.zzcqe);
        }
        hashMap.put("gnt", zzjr2.zzcqf);
        hashMap.put("pt", zzjr2.zzcqg);
        hashMap.put("rm", zzjr2.zzcqh);
        hashMap.put("riv", zzjr2.zzcqi);
        Bundle bundle4 = new Bundle();
        bundle4.putString("build", zzjr2.zzcqn);
        Bundle bundle5 = new Bundle();
        bundle5.putBoolean("is_charging", zzjr2.zzcqk);
        bundle5.putDouble("battery_level", zzjr2.zzcqj);
        bundle4.putBundle("battery", bundle5);
        Bundle bundle6 = new Bundle();
        bundle6.putInt("active_network_state", zzjr2.zzcqm);
        bundle6.putBoolean("active_network_metered", zzjr2.zzcql);
        if (zza2 != null) {
            bundle3 = new Bundle();
            bundle3.putInt("predicted_latency_micros", zza2.zzcqt);
            bundle3.putLong("predicted_down_throughput_bps", zza2.zzcqu);
            bundle3.putLong("predicted_up_throughput_bps", zza2.zzcqv);
            bundle6.putBundle("predictions", bundle3);
        }
        bundle4.putBundle("network", bundle6);
        bundle3 = new Bundle();
        bundle3.putBoolean("is_browser_custom_tabs_capable", zzjr2.zzcqo);
        bundle4.putBundle("browser", bundle3);
        if (bundle != null) {
            bundle4.putBundle("android_mem_info", zzjm.zzg(bundle));
        }
        Bundle bundle7 = new Bundle();
        bundle7.putBundle("parental_controls", bundle2);
        bundle4.putBundle("play_store", bundle7);
        hashMap.put("device", bundle4);
    }

    private static Bundle zzg(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzbbx) != 0) {
            hashMap.put("acolor", zzjm.zzaz(searchAdRequestParcel.zzbbx));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzjm.zzaz(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzbby) != 0 && Color.alpha((int)searchAdRequestParcel.zzbbz) != 0) {
            hashMap.put("gradientto", zzjm.zzaz(searchAdRequestParcel.zzbby));
            hashMap.put("gradientfrom", zzjm.zzaz(searchAdRequestParcel.zzbbz));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzbca) != 0) {
            hashMap.put("bcolor", zzjm.zzaz(searchAdRequestParcel.zzbca));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzbcb));
        switch (searchAdRequestParcel.zzbcc) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzbcd) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzbce != null) {
            hashMap.put("channel", searchAdRequestParcel.zzbce);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzbcf) != 0) {
            hashMap.put("dcolor", zzjm.zzaz(searchAdRequestParcel.zzbcf));
        }
        if (searchAdRequestParcel.zzbcg != null) {
            hashMap.put("font", searchAdRequestParcel.zzbcg);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzbch) != 0) {
            hashMap.put("hcolor", zzjm.zzaz(searchAdRequestParcel.zzbch));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzbci));
        if (searchAdRequestParcel.zzbcj != null) {
            hashMap.put("q", searchAdRequestParcel.zzbcj);
        }
    }

    private static Integer zzac(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzaz(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzbok : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_slot_size", string5);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzcka != 0;
            String string7 = jSONObject.optString("ad_json", null);
            if (string7 == null) {
                string7 = jSONObject.optString("ad_html", null);
            }
            if (string7 == null) {
                string7 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string8 = jSONObject.optString("debug_dialog", null);
            String string9 = jSONObject.optString("debug_signals", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string10 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string10)) {
                n = zzu.zzgo().zzvx();
            } else if ("landscape".equals(string10)) {
                n = zzu.zzgo().zzvw();
            }
            AdResponseParcel adResponseParcel = null;
            if (TextUtils.isEmpty((CharSequence)string7) && !TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzjl.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzari.zzda, string4, null, null, null, null);
                string3 = adResponseParcel.zzcbo;
                string7 = adResponseParcel.body;
                l = adResponseParcel.zzclf;
            }
            if (string7 == null) {
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzbvk;
            if (jSONArray != null) {
                list3 = zzjm.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzbvl;
            if (jSONArray2 != null) {
                list2 = zzjm.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzcld;
            if (jSONArray3 != null) {
                list = zzjm.zza(jSONArray3, list);
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzcla > 0L) {
                    l2 = adResponseParcel.zzcla;
                }
            }
            String string11 = jSONObject.optString("active_view");
            String string12 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string12 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("content_vertical_opted_out", true);
            boolean bl7 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string13 = jSONObject.optString("gws_query_id", "");
            boolean bl8 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl9 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zzjm.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zzjm.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            RewardItemParcel rewardItemParcel = RewardItemParcel.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl10 = jSONObject.optBoolean("use_displayed_impression", false);
            AutoClickProtectionConfigurationParcel autoClickProtectionConfigurationParcel = AutoClickProtectionConfigurationParcel.zzh(jSONObject.optJSONObject("auto_protection_configuration"));
            String string14 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zzjm.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            SafeBrowsingConfigParcel safeBrowsingConfigParcel = SafeBrowsingConfigParcel.zzj(jSONObject.optJSONObject("safe_browsing"));
            boolean bl11 = jSONObject.optBoolean("render_in_browser", adRequestInfoParcel.zzbvo);
            return new AdResponseParcel(adRequestInfoParcel, string3, string7, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string8, bl2, string12, string11, bl4, bl, adRequestInfoParcel.zzckc, bl5, bl7, string13, bl8, bl9, rewardItemParcel, list7, list8, bl10, autoClickProtectionConfigurationParcel, adRequestInfoParcel.zzcks, string14, list9, bl11, string6, safeBrowsingConfigParcel, string9, bl6);
        }
        catch (JSONException jSONException) {
            String string15 = String.valueOf(jSONException.getMessage());
            zzkx.zzdi((String)(string15.length() != 0 ? "Could not parse the inline ad response: ".concat(string15) : new String("Could not parse the inline ad response: ")));
            return new AdResponseParcel(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(AdResponseParcel adResponseParcel) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (adResponseParcel.zzcbo != null) {
            jSONObject.put("ad_base_url", (Object)adResponseParcel.zzcbo);
        }
        if (adResponseParcel.zzcle != null) {
            jSONObject.put("ad_size", (Object)adResponseParcel.zzcle);
        }
        jSONObject.put("native", adResponseParcel.zzazt);
        if (adResponseParcel.zzazt) {
            jSONObject.put("ad_json", (Object)adResponseParcel.body);
        } else {
            jSONObject.put("ad_html", (Object)adResponseParcel.body);
        }
        if (adResponseParcel.zzclg != null) {
            jSONObject.put("debug_dialog", (Object)adResponseParcel.zzclg);
        }
        if (adResponseParcel.zzclx != null) {
            jSONObject.put("debug_signals", (Object)adResponseParcel.zzclx);
        }
        if (adResponseParcel.zzcla != -1L) {
            jSONObject.put("interstitial_timeout", (double)adResponseParcel.zzcla / 1000.0);
        }
        if (adResponseParcel.orientation == zzu.zzgo().zzvx()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (adResponseParcel.orientation == zzu.zzgo().zzvw()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (adResponseParcel.zzbvk != null) {
            jSONObject.put("click_urls", (Object)zzjm.zzl(adResponseParcel.zzbvk));
        }
        if (adResponseParcel.zzbvl != null) {
            jSONObject.put("impression_urls", (Object)zzjm.zzl(adResponseParcel.zzbvl));
        }
        if (adResponseParcel.zzcld != null) {
            jSONObject.put("manual_impression_urls", (Object)zzjm.zzl(adResponseParcel.zzcld));
        }
        if (adResponseParcel.zzclj != null) {
            jSONObject.put("active_view", (Object)adResponseParcel.zzclj);
        }
        jSONObject.put("ad_is_javascript", adResponseParcel.zzclh);
        if (adResponseParcel.zzcli != null) {
            jSONObject.put("ad_passback_url", (Object)adResponseParcel.zzcli);
        }
        jSONObject.put("mediation", adResponseParcel.zzclb);
        jSONObject.put("custom_render_allowed", adResponseParcel.zzclk);
        jSONObject.put("content_url_opted_out", adResponseParcel.zzcll);
        jSONObject.put("content_vertical_opted_out", adResponseParcel.zzcly);
        jSONObject.put("prefetch", adResponseParcel.zzclm);
        if (adResponseParcel.zzbvq != -1L) {
            jSONObject.put("refresh_interval_milliseconds", adResponseParcel.zzbvq);
        }
        if (adResponseParcel.zzclc != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", adResponseParcel.zzclc);
        }
        if (!TextUtils.isEmpty((CharSequence)adResponseParcel.zzclp)) {
            jSONObject.put("gws_query_id", (Object)adResponseParcel.zzclp);
        }
        jSONObject.put("fluid", (Object)(adResponseParcel.zzazu ? "height" : ""));
        jSONObject.put("native_express", adResponseParcel.zzazv);
        if (adResponseParcel.zzclr != null) {
            jSONObject.put("video_start_urls", (Object)zzjm.zzl(adResponseParcel.zzclr));
        }
        if (adResponseParcel.zzcls != null) {
            jSONObject.put("video_complete_urls", (Object)zzjm.zzl(adResponseParcel.zzcls));
        }
        if (adResponseParcel.zzclq != null) {
            jSONObject.put("rewards", (Object)adResponseParcel.zzclq.zzue());
        }
        jSONObject.put("use_displayed_impression", adResponseParcel.zzclt);
        jSONObject.put("auto_protection_configuration", (Object)adResponseParcel.zzclu);
        jSONObject.put("render_in_browser", adResponseParcel.zzbvo);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzl(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

