/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzla;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@zzji
public class zzle {
    private final Context mContext;
    private String zzcvu;
    private String zzant;
    private final float zzbzc;
    private float zzcvv;
    private float zzcvw;
    private float zzcvx;
    private int mState = 0;

    public zzle(Context context) {
        this.mContext = context;
        this.zzbzc = context.getResources().getDisplayMetrics().density;
    }

    public zzle(Context context, String string2) {
        this(context);
        this.zzcvu = string2;
    }

    public void zzg(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzcvv = f;
            this.zzcvw = f2;
            this.zzcvx = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzcvw) {
                    this.zzcvw = f2;
                } else if (f2 < this.zzcvx) {
                    this.zzcvx = f2;
                }
                if (this.zzcvw - this.zzcvx > 30.0f * this.zzbzc) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzcvv >= 50.0f * this.zzbzc) {
                        this.zzcvv = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzcvv <= -50.0f * this.zzbzc) {
                    this.zzcvv = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzcvv) {
                        this.zzcvv = f;
                    }
                } else if (this.mState == 2 && f < this.zzcvv) {
                    this.zzcvv = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void showDialog() {
        if (zzdr.zzbkx.get().booleanValue() || zzdr.zzbkw.get().booleanValue()) {
            this.zzwb();
        } else {
            this.zzwc();
        }
    }

    public void setAdUnitId(String string2) {
        this.zzant = string2;
    }

    public void zzdc(String string2) {
        this.zzcvu = string2;
    }

    private void zzwb() {
        if (!(this.mContext instanceof Activity)) {
            zzkx.zzdh((String)"Can not create dialog without Activity Context");
            return;
        }
        Resources resources = zzu.zzgq().getResources();
        String string2 = resources != null ? resources.getString(R.string.debug_menu_title) : "Select a Debug Mode";
        String string3 = resources != null ? resources.getString(R.string.debug_menu_ad_information) : "Ad Information";
        String string4 = resources != null ? resources.getString(R.string.debug_menu_creative_preview) : "Creative Preview";
        String string5 = resources != null ? resources.getString(R.string.debug_menu_troubleshooting) : "Troubleshooting";
        ArrayList<String> arrayList = new ArrayList<String>();
        final int n = this.zza(arrayList, string3, true);
        final int n2 = this.zza(arrayList, string4, zzdr.zzbkw.get());
        final int n3 = this.zza(arrayList, string5, zzdr.zzbkx.get());
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)string2).setItems((CharSequence[])arrayList.toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n4) {
                if (n4 == n) {
                    zzle.this.zzwc();
                } else if (n4 == n2 && zzdr.zzbkw.get().booleanValue()) {
                    zzle.this.zzwd();
                } else if (n4 == n3 && zzdr.zzbkx.get().booleanValue()) {
                    zzle.this.zzwe();
                }
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private int zza(List<String> list, String string2, boolean bl) {
        if (!bl) {
            return -1;
        }
        list.add(string2);
        return list.size() - 1;
    }

    private void zzwc() {
        if (!(this.mContext instanceof Activity)) {
            zzkx.zzdh((String)"Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzle.zzdd(this.zzcvu);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzu.zzgm().zzb(zzle.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private void zzwd() {
        zzkx.zzdg((String)"Debug mode [Creative Preview] selected.");
        zzla.zza(new Runnable(){

            @Override
            public void run() {
                zzu.zzgu().zzj(zzle.this.mContext, zzle.this.zzant);
            }
        });
    }

    private void zzwe() {
        zzkx.zzdg((String)"Debug mode [Troubleshooting] selected.");
        zzla.zza(new Runnable(){

            @Override
            public void run() {
                zzu.zzgu().zzk(zzle.this.mContext, zzle.this.zzant);
            }
        });
    }

    static String zzdd(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzu.zzgm().zzg(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

