/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsv;
import com.google.android.gms.internal.zzsz;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztm;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzsg
extends zzsa
implements Closeable {
    private static final String zzaeu = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzaev = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zza zzaew;
    private final zztj zzaex = new zztj(this.zznR());
    private final zztj zzaey = new zztj(this.zznR());

    zzsg(zzsc zzsc2) {
        super(zzsc2);
        String string = this.zzow();
        this.zzaew = new zza(zzsc2.getContext(), string);
    }

    @Override
    protected void zzmS() {
    }

    public void beginTransaction() {
        this.zzob();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zzob();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zzob();
        this.getWritableDatabase().endTransaction();
    }

    public void zzor() {
        this.zzmR();
        this.zzob();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("hits2", null, null);
    }

    public void zzos() {
        this.zzmR();
        this.zzob();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("properties", null, null);
    }

    public void zzc(zzsz zzsz2) {
        zzac.zzw((Object)zzsz2);
        this.zzmR();
        this.zzob();
        String string = zzsg.zze(zzsz2);
        if (string.length() > 8192) {
            this.zznS().zza(zzsz2, "Hit length exceeds the maximum allowed size");
            return;
        }
        this.zzov();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string);
        contentValues.put("hit_time", Long.valueOf(zzsz2.zzpQ()));
        contentValues.put("hit_app_id", Integer.valueOf(zzsz2.zzpO()));
        contentValues.put("hit_url", this.zzd(zzsz2));
        try {
            long l = sQLiteDatabase.insert("hits2", null, contentValues);
            if (l == -1L) {
                this.zzbT("Failed to insert a hit (got -1)");
            } else {
                this.zzb("Hit saved to database. db-id, hit", l, zzsz2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
        }
    }

    public long zzom() {
        this.zzmR();
        this.zzob();
        long l = this.zzb("SELECT COUNT(*) FROM hits2", null);
        return l;
    }

    boolean isEmpty() {
        return this.zzom() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> zzt(long l) {
        this.zzmR();
        this.zzob();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public List<zzsz> zzu(long l) {
        zzac.zzax((l >= 0L ? 1 : 0) != 0);
        this.zzmR();
        this.zzob();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzsz> arrayList = new ArrayList<zzsz>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzbU(string);
                    boolean bl = zztm.zzcj(string2);
                    arrayList.add(new zzsz(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzsz> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzr(List<Long> list) {
        Long l;
        zzac.zzw(list);
        this.zzmR();
        this.zzob();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public void zzv(long l) {
        this.zzmR();
        this.zzob();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zzr(arrayList);
    }

    public int zzot() {
        this.zzmR();
        this.zzob();
        if (!this.zzaex.zzA(86400000L)) {
            return 0;
        }
        this.zzaex.start();
        this.zzbP("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zznR().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public long zzou() {
        this.zzmR();
        this.zzob();
        return this.zza(zzaev, null, 0L);
    }

    public void zza(long l, String string) {
        zzac.zzdr((String)string);
        this.zzob();
        this.zzmR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l), string});
        if (n > 0) {
            this.zza("Deleted property records", n);
        }
    }

    public void zzb(zzse zzse2) {
        zzac.zzw((Object)zzse2);
        this.zzob();
        this.zzmR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String string = zzsg.zzT(zzse2.zzfE());
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_uid", Long.valueOf(zzse2.zzoj()));
        contentValues.put("cid", zzse2.zzmy());
        contentValues.put("tid", zzse2.zzok());
        contentValues.put("adid", Integer.valueOf(zzse2.zzol() ? 1 : 0));
        contentValues.put("hits_count", Long.valueOf(zzse2.zzom()));
        contentValues.put("params", string);
        try {
            long l = sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5);
            if (l == -1L) {
                this.zzbT("Failed to insert/update a property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a property", (Object)sQLiteException);
        }
    }

    public long zza(long l, String string, String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzob();
        this.zzmR();
        long l2 = this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
        return l2;
    }

    public List<zzse> zzw(long l) {
        this.zzob();
        this.zzmR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = this.zznT().zzpu();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{String.valueOf(l)};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzse> arrayList = new ArrayList<zzse>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzbV(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzse zzse2 = new zzse(l, (String)object, string3, bl, l2, map);
                    arrayList.add(zzse2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzbS("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public void close() {
        try {
            this.zzaew.close();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
        }
    }

    private String zzd(zzsz zzsz2) {
        if (zzsz2.zzpS()) {
            return this.zznT().zzpj();
        }
        return this.zznT().zzpk();
    }

    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return l;
        }
    }

    private void zzov() {
        int n = this.zznT().zzpt();
        long l = this.zzom();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = this.zzt(l2);
            this.zzd("Store full, deleting hits to make room, count", list.size());
            this.zzr(list);
        }
    }

    private static String zze(zzsz zzsz2) {
        zzac.zzw((Object)zzsz2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : zzsz2.zzfE().entrySet()) {
            String string = object2.getKey();
            if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string)) continue;
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String zzT(Map<String, String> map) {
        zzac.zzw(map);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string = object2.getKey();
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    Map<String, String> zzbU(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2;
            if (string.startsWith("?")) {
                string2 = string;
            } else {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            String string4 = string2;
            return zzo.zza((URI)new URI(string4), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    Map<String, String> zzbV(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "?".concat(string2) : new String("?");
            return zzo.zza((URI)new URI(string3), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzaew.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zzow() {
        return this.zznT().zzpv();
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzsg.this.zzaey.zzA(3600000L)) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzsg.this.zzaey.start();
                zzsg.this.zzbT("Opening the database failed, dropping the table and recreating it");
                String string = zzsg.this.zzow();
                zzsg.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzsg.this.zzaey.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzsg.this.zze("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "hits2");
            String[] stringArray2 = stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"};
            for (int i = 0; i < 4; ++i) {
                String string = stringArray2[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database hits2 is missing required column: ".concat(string2) : new String("Database hits2 is missing required column: "));
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase.execSQL(string);
            }
        }

        private void zzb(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "properties");
            String[] stringArray2 = stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"};
            for (int i = 0; i < 6; ++i) {
                String string = stringArray2[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database properties is missing required column: ".concat(string2) : new String("Database properties is missing required column: "));
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database properties table has extra columns");
            }
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza(sQLiteDatabase, "hits2")) {
                sQLiteDatabase.execSQL(zzaeu);
            } else {
                this.zza(sQLiteDatabase);
            }
            if (!this.zza(sQLiteDatabase, "properties")) {
                sQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            } else {
                this.zzb(sQLiteDatabase);
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzsv.zzca(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }
}

