/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.internal.zztm;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzh {
    private static volatile zzh zzach;
    private final Context mContext;
    private final List<Object> zzaci;
    private final zzd zzacj;
    private final zza zzack;
    private volatile zzrk zzacl;
    private Thread.UncaughtExceptionHandler zzacm;

    zzh(Context context) {
        Context context2 = context.getApplicationContext();
        zzac.zzw((Object)context2);
        this.mContext = context2;
        this.zzack = new zza();
        this.zzaci = new CopyOnWriteArrayList<Object>();
        this.zzacj = new zzd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzh zzam(Context context) {
        zzac.zzw((Object)context);
        if (zzach != null) return zzach;
        Class<zzh> clazz = zzh.class;
        synchronized (zzh.class) {
            if (zzach != null) return zzach;
            zzach = new zzh(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzach;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzrk zzmP() {
        if (this.zzacl == null) {
            zzh zzh2 = this;
            synchronized (zzh2) {
                if (this.zzacl == null) {
                    zzrk zzrk2 = new zzrk();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzrk2.setAppId(string);
                    zzrk2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzrk2.setAppName(string2);
                    zzrk2.setAppVersion(string3);
                    this.zzacl = zzrk2;
                }
            }
        }
        return this.zzacl;
    }

    public zzrp zzmQ() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzrp zzrp2 = new zzrp();
        zzrp2.setLanguage(zztm.zza(Locale.getDefault()));
        zzrp2.zzaB(displayMetrics.widthPixels);
        zzrp2.zzaC(displayMetrics.heightPixels);
        return zzrp2;
    }

    void zze(zze zze2) {
        if (zze2.zzmL()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zze2.zzmH()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final zze zze3 = zze2.zzmC();
        zze3.zzmI();
        this.zzack.execute(new Runnable(){

            @Override
            public void run() {
                zzg zzg2 = zze3.zzmJ();
                zzg2.zza(zze3);
                Iterator iterator = zzh.this.zzaci.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
                zzh.this.zzb(zze3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzmR() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzacm = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzc(Callable<V> callable) {
        zzac.zzw(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzack.submit(callable);
    }

    public void zzg(Runnable runnable) {
        zzac.zzw((Object)runnable);
        this.zzack.submit(runnable);
    }

    private void zzb(zze zze2) {
        zzac.zzdk((String)"deliver should be called from worker thread");
        zzac.zzb((boolean)zze2.zzmH(), (Object)"Measurement must be submitted");
        List<zzi> list = zze2.zzmE();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzi zzi2 : list) {
            Uri uri = zzi2.zzmr();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzi2.zzb(zze2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzacq = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            int n = zzacq.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new FutureTask<T>(runnable, t){

                @Override
                protected void setException(Throwable throwable) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzh.this.zzacm;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        String string = String.valueOf(throwable);
                        Log.e((String)"GAv4", (String)new StringBuilder(37 + String.valueOf(string).length()).append("MeasurementExecutor: job failed with ").append(string).toString());
                    }
                    super.setException(throwable);
                }
            };
        }
    }
}

