/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztm;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zzrx
extends zzsa {
    public static boolean zzadA;
    private AdvertisingIdClient.Info zzadB;
    private final zztj zzadC;
    private String zzadD;
    private boolean zzadE = false;
    private Object zzadF = new Object();

    zzrx(zzsc zzsc2) {
        super(zzsc2);
        this.zzadC = new zztj(zzsc2.zznR());
    }

    @Override
    protected void zzmS() {
    }

    public boolean zznw() {
        this.zzob();
        AdvertisingIdClient.Info info = this.zznH();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zznG() {
        this.zzob();
        AdvertisingIdClient.Info info = this.zznH();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zznH() {
        if (this.zzadC.zzA(1000L)) {
            this.zzadC.start();
            AdvertisingIdClient.Info info = this.zznI();
            if (this.zza(this.zzadB, info)) {
                this.zzadB = info;
            } else {
                this.zzbT("Failed to reset client id on adid change. Not using adid");
                this.zzadB = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzadB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zznX().zzoQ();
        Object object = this.zzadF;
        synchronized (object) {
            String string4;
            if (!this.zzadE) {
                this.zzadD = this.zznJ();
                this.zzadE = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzadD)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    String string6 = String.valueOf(string);
                    String string7 = String.valueOf(string3);
                    return this.zzbO(string7.length() != 0 ? string6.concat(string7) : new String(string6));
                }
                String string8 = String.valueOf(string4);
                String string9 = String.valueOf(string3);
                this.zzadD = zzrx.zzbN(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string3);
            string4 = zzrx.zzbN(string11.length() != 0 ? string10.concat(string11) : new String(string10));
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzadD)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzadD)) {
                this.zzbP("Resetting the client id because Advertising Id changed.");
                string3 = this.zznX().zzoR();
                this.zza("New client Id", string3);
            }
            String string12 = String.valueOf(string);
            String string13 = String.valueOf(string3);
            return this.zzbO(string13.length() != 0 ? string12.concat(string13) : new String(string12));
        }
    }

    protected AdvertisingIdClient.Info zznI() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbS("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzadA) break block3;
                zzadA = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzbN(String string) {
        MessageDigest messageDigest = zztm.zzch("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzbO(String string) {
        try {
            String string2 = zzrx.zzbN(string);
            this.zzbP("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzadD = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zznJ() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbS("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzbP("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

