/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzsk
extends zzsa {
    private volatile String zzadh;
    private Future<String> zzaeS;

    protected zzsk(zzsc zzsc2) {
        super(zzsc2);
    }

    @Override
    protected void zzmS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzoQ() {
        this.zzob();
        zzsk zzsk2 = this;
        synchronized (zzsk2) {
            if (this.zzadh == null) {
                this.zzaeS = this.zznU().zzc(new Callable<String>(){

                    public String zzbY() throws Exception {
                        return zzsk.this.zzoS();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzbY();
                    }
                });
            }
            if (this.zzaeS != null) {
                try {
                    this.zzadh = this.zzaeS.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzadh = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzadh = "0";
                }
                if (this.zzadh == null) {
                    this.zzadh = "0";
                }
                this.zza("Loaded clientId", this.zzadh);
                this.zzaeS = null;
            }
            return this.zzadh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzoR() {
        zzsk zzsk2 = this;
        synchronized (zzsk2) {
            this.zzadh = null;
            this.zzaeS = this.zznU().zzc(new Callable<String>(){

                public String zzbY() throws Exception {
                    return zzsk.this.zzoT();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzbY();
                }
            });
        }
        return this.zzoQ();
    }

    String zzoS() {
        String string = this.zzap(this.zznU().getContext());
        if (string == null) {
            string = this.zzoT();
        }
        return string;
    }

    private String zzoT() {
        String string = this.zzoU();
        try {
            if (!this.zzx(this.zznU().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    protected String zzoU() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzap(Context context) {
        zzac.zzdk((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzbS("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzbS("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzx(Context context, String string) {
        zzac.zzdr((String)string);
        zzac.zzdk((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

