/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zztd;

class zzte
extends BroadcastReceiver {
    static final String zzagv = zzte.class.getName();
    private final zzsc zzadO;
    private boolean zzagw;
    private boolean zzagx;

    zzte(zzsc zzsc2) {
        zzac.zzw((Object)zzsc2);
        this.zzadO = zzsc2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzpY();
        String string = intent.getAction();
        this.zzadO.zznS().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzqa();
            if (this.zzagx != bl) {
                this.zzagx = bl;
                this.zzmA().zzV(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzagv)) {
                this.zzmA().zznO();
            }
            return;
        }
        this.zzadO.zznS().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzpX() {
        this.zzpY();
        if (this.zzagw) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzagx = this.zzqa();
        this.zzadO.zznS().zza("Registering connectivity change receiver. Network connected", this.zzagx);
        this.zzagw = true;
    }

    private void zzpY() {
        this.zznS();
        this.zzmA();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzadO.zznS().zzbP("Unregistering connectivity change receiver");
        this.zzagw = false;
        this.zzagx = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zznS().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzpZ() {
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzagv, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzagw;
    }

    public boolean isConnected() {
        if (!this.zzagw) {
            this.zzadO.zznS().zzbS("Connectivity unknown. Receiver not registered");
        }
        return this.zzagx;
    }

    protected boolean zzqa() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzadO.getContext();
    }

    private zztd zznS() {
        return this.zzadO.zznS();
    }

    private zzry zzmA() {
        return this.zzadO.zzmA();
    }
}

