/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzalo;
import com.google.android.gms.internal.zzaor;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzl {
    private static volatile zzl zzaed;
    private final Context mContext;
    private final List<Object> zzaee;
    private final zzg zzaef;
    private final zza zzaeg;
    private volatile zzalj zzaeh;
    private Thread.UncaughtExceptionHandler zzaei;

    private zzl(Context context) {
        Context context2 = context.getApplicationContext();
        zzbo.zzu((Object)context2);
        this.mContext = context2;
        this.zzaeg = new zza();
        this.zzaee = new CopyOnWriteArrayList<Object>();
        this.zzaef = new zzg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzl zzae(Context context) {
        zzbo.zzu((Object)context);
        if (zzaed != null) return zzaed;
        Class<zzl> clazz = zzl.class;
        synchronized (zzl.class) {
            if (zzaed != null) return zzaed;
            zzaed = new zzl(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzalj zzjA() {
        if (this.zzaeh == null) {
            zzl zzl2 = this;
            synchronized (zzl2) {
                if (this.zzaeh == null) {
                    zzalj zzalj2 = new zzalj();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzalj2.setAppId(string);
                    zzalj2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzalj2.setAppName(string2);
                    zzalj2.setAppVersion(string3);
                    this.zzaeh = zzalj2;
                }
            }
        }
        return this.zzaeh;
    }

    public final zzalo zzjB() {
        int n;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzalo zzalo2 = new zzalo();
        zzalo2.setLanguage(zzaor.zza(Locale.getDefault()));
        zzalo2.zzNY = n = displayMetrics.widthPixels;
        zzalo2.zzNZ = n = displayMetrics.heightPixels;
        return zzalo2;
    }

    final void zze(zzi zzi2) {
        if (zzi2.zzjx()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzi2.zzju()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzi zzi3 = zzi2.zzjp();
        zzi3.zzjv();
        this.zzaeg.execute(new zzm(this, zzi3));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public static void zzjC() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaei = uncaughtExceptionHandler;
    }

    public final <V> Future<V> zzd(Callable<V> callable) {
        zzbo.zzu(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaeg.submit(callable);
    }

    public final void zzf(Runnable runnable) {
        zzbo.zzu((Object)runnable);
        this.zzaeg.submit(runnable);
    }

    private static void zzb(zzi zzi2) {
        zzbo.zzcG((String)"deliver should be called from worker thread");
        zzbo.zzb((boolean)zzi2.zzju(), (Object)"Measurement must be submitted");
        List<zzo> list = zzi2.zzjr();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzo zzo2 : list) {
            Uri uri = zzo2.zzjl();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzo2.zzb(zzi2);
        }
    }

    static /* synthetic */ List zza(zzl zzl2) {
        return zzl2.zzaee;
    }

    static /* synthetic */ void zza(zzl zzl2, zzi zzi2) {
        zzl.zzb(zzi2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzl zzl2) {
        return zzl2.zzaei;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaem = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zzaem.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzm zzm2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzn(this, runnable, t);
        }
    }
}

