/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamn;
import com.google.android.gms.internal.zzamo;
import com.google.android.gms.internal.zzand;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzanl;
import com.google.android.gms.internal.zzanr;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzaon;
import java.util.Collections;
import java.util.List;

public final class zzamm
extends zzamg {
    private final zzamo zzagg;
    private zzanx zzagh;
    private final zzanl zzagi;
    private zzaon zzagj;

    protected zzamm(zzami zzami2) {
        super(zzami2);
        this.zzagj = new zzaon(zzami2.zzkq());
        this.zzagg = new zzamo(this);
        this.zzagi = new zzamn(this, zzami2);
    }

    @Override
    protected final void zzjD() {
    }

    public final boolean isConnected() {
        zzl.zzjC();
        this.zzkD();
        return this.zzagh != null;
    }

    public final boolean zzb(zzanw zzanw2) {
        zzbo.zzu((Object)zzanw2);
        zzl.zzjC();
        this.zzkD();
        zzanx zzanx2 = this.zzagh;
        if (zzanx2 == null) {
            return false;
        }
        String string = zzanw2.zzlI() ? zzanj.zzlu() : zzanj.zzlv();
        List<zzand> list = Collections.emptyList();
        try {
            zzanx2.zza(zzanw2.zzdV(), zzanw2.zzlG(), string, list);
            this.zzkP();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbo("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzkO() {
        zzl.zzjC();
        this.zzkD();
        zzanx zzanx2 = this.zzagh;
        if (zzanx2 == null) {
            return false;
        }
        try {
            zzanx2.zzkk();
            this.zzkP();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbo("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzkP() {
        this.zzagj.start();
        this.zzagi.zzs(zzanr.zzahO.get());
    }

    public final boolean connect() {
        zzl.zzjC();
        this.zzkD();
        if (this.zzagh != null) {
            return true;
        }
        zzanx zzanx2 = this.zzagg.zzkR();
        if (zzanx2 != null) {
            this.zzagh = zzanx2;
            this.zzkP();
            return true;
        }
        return false;
    }

    private final void zza(zzanx zzanx2) {
        zzl.zzjC();
        this.zzagh = zzanx2;
        this.zzkP();
        this.zzkv().onServiceConnected();
    }

    public final void disconnect() {
        zzl.zzjC();
        this.zzkD();
        try {
            zza.zzrU();
            zzamo zzamo2 = this.zzagg;
            Context context = this.getContext();
            context.unbindService((ServiceConnection)zzamo2);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzagh != null) {
            this.zzagh = null;
            this.zzkv().zzkn();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzl.zzjC();
        if (this.zzagh != null) {
            this.zzagh = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzkv().zzkn();
        }
    }

    private final void zzkQ() {
        zzl.zzjC();
        if (!this.isConnected()) {
            return;
        }
        this.zzbo("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzamo zza(zzamm zzamm2) {
        return zzamm2.zzagg;
    }

    static /* synthetic */ void zza(zzamm zzamm2, zzanx zzanx2) {
        zzamm2.zza(zzanx2);
    }

    static /* synthetic */ void zza(zzamm zzamm2, ComponentName componentName) {
        zzamm2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzamm zzamm2) {
        zzamm2.zzkQ();
    }
}

