/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzalk;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalo;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzamn;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzanq;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoe;
import com.google.android.gms.internal.zzaoj;
import com.google.android.gms.internal.zzaok;
import com.google.android.gms.internal.zzaoo;
import com.google.android.gms.internal.zzaos;
import com.google.android.gms.internal.zzaot;
import com.google.android.gms.internal.zzbha;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzamv
extends zzamh {
    private boolean mStarted;
    private final zzams zzagv;
    private final zzaoe zzagw;
    private final zzaod zzagx;
    private final zzamn zzagy;
    private long zzagz;
    private final zzanm zzagA;
    private final zzanm zzagB;
    private final zzaoo zzagC;
    private long zzagD;
    private boolean zzagE;

    protected zzamv(zzamj zzamj2, zzaml zzaml2) {
        super(zzamj2);
        zzbo.zzu((Object)zzaml2);
        this.zzagz = Long.MIN_VALUE;
        zzamj zzamj3 = zzamj2;
        this.zzagx = new zzaod(zzamj3);
        zzamj3 = zzamj2;
        this.zzagv = new zzams(zzamj3);
        zzamj3 = zzamj2;
        this.zzagw = new zzaoe(zzamj3);
        zzamj3 = zzamj2;
        this.zzagy = new zzamn(zzamj3);
        this.zzagC = new zzaoo(this.zzkq());
        this.zzagA = new zzamw(this, zzamj2);
        this.zzagB = new zzamx(this, zzamj2);
    }

    @Override
    protected final void zzjD() {
        this.zzagv.initialize();
        this.zzagw.initialize();
        this.zzagy.initialize();
    }

    final void start() {
        this.zzkD();
        zzbo.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzkt().zzf(new zzamy(this));
    }

    private final boolean zzbv(String string) {
        return zzbha.zzaP((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzkX() {
        this.zzkD();
        zzamv zzamv2 = this;
        zzl.zzjC();
        Context context = zzamv2.zzkp().getContext();
        if (!zzaoj.zzac(context)) {
            zzamv2.zzbr("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzaok.zzad(context)) {
            zzamv2.zzbs("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzac(context)) {
            zzamv2.zzbr("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!CampaignTrackingService.zzad(context)) {
            zzamv2.zzbr("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzky().zzlU();
        if (!this.zzbv("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbs("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzlh();
        }
        if (!this.zzbv("android.permission.INTERNET")) {
            this.zzbs("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzlh();
        }
        if (zzaok.zzad(this.getContext())) {
            this.zzbo("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzbr("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzagE && !this.zzagv.isEmpty()) {
            this.zzla();
        }
        this.zzld();
    }

    private final void zzkY() {
        this.zzb(new zzamz(this));
    }

    final void zzko() {
        zzl.zzjC();
        this.zzagD = this.zzkq().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzl.zzjC();
        zzamv zzamv2 = this;
        zzl.zzjC();
        zzamv2.zzkD();
        if (!zzank.zzlo()) {
            zzamv2.zzbr("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzamv2.zzagy.isConnected()) {
            zzamv2.zzbo("Service not connected");
            return;
        }
        if (!zzamv2.zzagv.isEmpty()) {
            zzamv2.zzbo("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzanx> list;
                try {
                    list = zzamv2.zzagv.zzo(zzank.zzls());
                    if (list.isEmpty()) {
                        zzamv2.zzld();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzamv2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzamv2.zzlf();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzanx zzanx2 = list.get(0);
                    if (!zzamv2.zzagy.zzb(zzanx2)) {
                        zzamv2.zzld();
                        return;
                    }
                    list.remove(zzanx2);
                    try {
                        zzamv2.zzagv.zzp(zzanx2.zzlF());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzamv2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzamv2.zzlf();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzkZ() {
        try {
            this.zzagv.zzkS();
            this.zzld();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzagB.zzs(86400000L);
    }

    protected final void zzb(zzamm zzamm2) {
        zzl.zzjC();
        this.zzb("Sending first hit to property", zzamm2.zzkL());
        if (this.zzky().zzlV().zzu(zzank.zzly())) {
            return;
        }
        String string = this.zzky().zzlY();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzall zzall2 = zzaos.zza(this.zzkr(), string);
        this.zzb("Found relevant installation campaign", zzall2);
        this.zza(zzamm2, zzall2);
    }

    public final void zzr(long l) {
        zzl.zzjC();
        this.zzkD();
        if (l < 0L) {
            l = 0L;
        }
        this.zzagz = l;
        this.zzld();
    }

    private final void zzla() {
        if (this.zzagE) {
            return;
        }
        if (!zzank.zzlo()) {
            return;
        }
        if (this.zzagy.isConnected()) {
            return;
        }
        long l = zzans.zzahS.get();
        if (this.zzagC.zzu(l)) {
            this.zzagC.start();
            this.zzbo("Connecting to service");
            if (this.zzagy.connect()) {
                this.zzbo("Connected to service");
                this.zzagC.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzamm zzamm2, boolean bl) {
        long l;
        zzbo.zzu((Object)zzamm2);
        this.zzkD();
        zzl.zzjC();
        try {
            this.zzagv.beginTransaction();
            String string = zzamm2.zzjX();
            long l2 = zzamm2.zzkK();
            zzams zzams2 = this.zzagv;
            zzbo.zzcF((String)string);
            zzams2.zzkD();
            zzl.zzjC();
            int n = zzams2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzams2.zza("Deleted property records", n);
            }
            l = this.zzagv.zza(zzamm2.zzkK(), zzamm2.zzjX(), zzamm2.zzkL());
            zzamm2.zzm(l + 1L);
            zzamm zzamm3 = zzamm2;
            zzams zzams3 = this.zzagv;
            zzbo.zzu((Object)zzamm3);
            zzams3.zzkD();
            zzl.zzjC();
            SQLiteDatabase sQLiteDatabase = zzams3.getWritableDatabase();
            Map<String, String> map = zzamm3.zzdV();
            zzbo.zzu(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzamm3.zzkK()));
            contentValues.put("cid", zzamm3.zzjX());
            contentValues.put("tid", zzamm3.zzkL());
            contentValues.put("adid", Integer.valueOf(zzamm3.zzkM() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzamm3.zzkN()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzams3.zzbs("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzams3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzagv.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzagv.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzanx zzanx2) {
        zzanx zzanx3;
        zzbo.zzu((Object)zzanx2);
        zzl.zzjC();
        this.zzkD();
        if (this.zzagE) {
            this.zzbp("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzanx2);
        }
        zzanx zzanx4 = zzanx2;
        zzamv zzamv2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzanx4.zzlK())) {
            zzanx3 = zzanx4;
        } else {
            Pair<String, Long> pair = zzamv2.zzky().zzlZ().zzmb();
            if (pair == null) {
                zzanx3 = zzanx4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzanx4.zzdV());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzanx zzanx5 = zzanx4;
                zzamv zzamv3 = zzamv2;
                zzanx3 = new zzanx(zzamv3, (Map<String, String>)object2, zzanx5.zzlG(), zzanx5.zzlI(), zzanx5.zzlF(), zzanx5.zzlE(), zzanx5.zzlH());
            }
        }
        zzanx2 = zzanx3;
        this.zzla();
        if (this.zzagy.zzb(zzanx2)) {
            this.zzbp("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzagv.zzc(zzanx2);
            this.zzld();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzkr().zza(zzanx2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzkk() {
        zzl.zzjC();
        this.zzkD();
        this.zzbo("Delete all hits from local store");
        try {
            zzams zzams2 = this.zzagv;
            zzl.zzjC();
            zzams2.zzkD();
            zzams2.getWritableDatabase().delete("hits2", null, null);
            zzams2 = this.zzagv;
            zzl.zzjC();
            zzams2.zzkD();
            zzams2.getWritableDatabase().delete("properties", null, null);
            this.zzld();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzla();
        if (this.zzagy.zzkO()) {
            this.zzbo("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzlb() {
        boolean bl;
        zzl.zzjC();
        this.zzkD();
        this.zzbo("Dispatching a batch of local hits");
        boolean bl2 = !this.zzagy.isConnected();
        boolean bl3 = bl = !this.zzagw.zzlQ();
        if (bl2 && bl) {
            this.zzbo("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzank.zzls(), zzank.zzlt());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzanx> list;
                block38: {
                    this.zzagv.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzagv.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbo("Store is empty, nothing to dispatch");
                        this.zzlf();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzlf();
                        try {
                            this.zzagv.setTransactionSuccessful();
                            this.zzagv.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzlf();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzlF() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzlf();
                    return false;
                }
                if (this.zzagy.isConnected()) {
                    this.zzbo("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzagy.zzb((zzanx)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzanx)((Object)list2)).zzlF());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzagv.zzp(((zzanx)((Object)list2)).zzlF());
                            arrayList.add(((zzanx)((Object)list2)).zzlF());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzlf();
                            try {
                                this.zzagv.setTransactionSuccessful();
                                this.zzagv.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzlf();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzagw.zzlQ()) {
                    list2 = this.zzagw.zzu(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzagv.zzs(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzlf();
                        try {
                            this.zzagv.setTransactionSuccessful();
                            this.zzagv.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzlf();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzagv.setTransactionSuccessful();
                    this.zzagv.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzlf();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzanq zzanq2) {
        long l = this.zzagD;
        zzanq zzanq3 = zzanq2;
        zzamv zzamv2 = this;
        zzl.zzjC();
        zzamv2.zzkD();
        long l2 = -1L;
        long l3 = zzamv2.zzky().zzlW();
        if (l3 != 0L) {
            l2 = Math.abs(zzamv2.zzkq().currentTimeMillis() - l3);
        }
        zzamv2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzamv2.zzla();
        try {
            zzamv2.zzlb();
            zzamv2.zzky().zzlX();
            zzamv2.zzld();
            if (zzanq3 != null) {
                zzanq3.zzc(null);
            }
            if (zzamv2.zzagD != l) {
                zzamv2.zzagx.zzlP();
            }
            return;
        }
        catch (Throwable throwable) {
            zzamv2.zze("Local dispatch failed", throwable);
            zzamv2.zzky().zzlX();
            zzamv2.zzld();
            if (zzanq3 != null) {
                zzanq3.zzc(throwable);
            }
            return;
        }
    }

    public final void zzlc() {
        zzl.zzjC();
        this.zzkD();
        this.zzbp("Sync dispatching local hits");
        long l = this.zzagD;
        this.zzla();
        try {
            this.zzlb();
            this.zzky().zzlX();
            this.zzld();
            if (this.zzagD != l) {
                this.zzagx.zzlP();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzld();
            return;
        }
    }

    private final long zzkT() {
        zzl.zzjC();
        this.zzkD();
        try {
            return this.zzagv.zzkT();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzld() {
        boolean bl;
        zzl.zzjC();
        this.zzkD();
        zzamv zzamv2 = this;
        if (!(!zzamv2.zzagE && zzamv2.zzlg() > 0L)) {
            this.zzagx.unregister();
            this.zzlf();
            return;
        }
        if (this.zzagv.isEmpty()) {
            this.zzagx.unregister();
            this.zzlf();
            return;
        }
        if (!zzans.zzahN.get().booleanValue()) {
            this.zzagx.zzlN();
            bl = this.zzagx.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzamv2 = this;
            zzamv2.zzle();
            long l3 = zzamv2.zzlg();
            long l4 = zzamv2.zzky().zzlW();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzamv2.zzkq().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzank.zzlq(), l3)) : Math.min(zzank.zzlq(), l3);
            zzamv2.zza("Dispatch scheduled (ms)", l5);
            if (zzamv2.zzagA.zzbo()) {
                l = Math.max(1L, l5 + zzamv2.zzagA.zzlz());
                zzamv2.zzagA.zzt(l);
                return;
            }
            zzamv2.zzagA.zzs(l5);
            return;
        }
        this.zzlf();
        this.zzle();
    }

    private final void zzle() {
        long l;
        zzanp zzanp2 = this.zzkw();
        if (!zzanp2.zzlC()) {
            return;
        }
        if (!zzanp2.zzbo() && (l = this.zzkT()) != 0L && Math.abs(this.zzkq().currentTimeMillis() - l) <= zzans.zzahr.get()) {
            long l2 = zzank.zzlr();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzanp2.schedule();
        }
    }

    private final void zzlf() {
        zzamv zzamv2 = this;
        if (zzamv2.zzagA.zzbo()) {
            zzamv2.zzbo("All hits dispatched or no network/service. Going to power save mode");
        }
        zzamv2.zzagA.cancel();
        zzanp zzanp2 = this.zzkw();
        if (zzanp2.zzbo()) {
            zzanp2.cancel();
        }
    }

    private final long zzlg() {
        if (this.zzagz != Long.MIN_VALUE) {
            return this.zzagz;
        }
        long l = zzans.zzahm.get();
        zzaot zzaot2 = this.zzkx();
        zzaot2.zzkD();
        if (zzaot2.zzaiP) {
            zzaot2 = this.zzkx();
            zzaot2.zzkD();
            l = (long)zzaot2.zzahZ * 1000L;
        }
        return l;
    }

    public final void zzbw(String string) {
        zzbo.zzcF((String)string);
        zzl.zzjC();
        zzall zzall2 = zzaos.zza(this.zzkr(), string);
        if (zzall2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzky().zzlY();
        if (string.equals(string2)) {
            this.zzbr("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzky().zzbz(string);
        if (this.zzky().zzlV().zzu(zzank.zzly())) {
            this.zzd("Campaign received too late, ignoring", zzall2);
            return;
        }
        this.zzb("Received installation campaign", zzall2);
        for (zzamm zzamm2 : this.zzagv.zzq(0L)) {
            this.zza(zzamm2, zzall2);
        }
    }

    private final void zza(zzamm zzamm2, zzall zzall2) {
        zzbo.zzu((Object)zzamm2);
        zzbo.zzu((Object)zzall2);
        zza zza2 = new zza(this.zzkp());
        zza2.zzaY(zzamm2.zzkL());
        zza2.enableAdvertisingIdCollection(zzamm2.zzkM());
        zzi zzi2 = zza2.zzjj();
        zzalt zzalt2 = zzi2.zzb(zzalt.class);
        zzalt2.zzbj("data");
        zzalt2.zzH(true);
        zzi2.zza(zzall2);
        zzalo zzalo2 = zzi2.zzb(zzalo.class);
        zzalk zzalk2 = zzi2.zzb(zzalk.class);
        for (Map.Entry<String, String> entry : zzamm2.zzdV().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzalk2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzalk2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzalk2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzalk2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzalt2.setUserId(string2);
                continue;
            }
            zzalo2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzamm2.zzkL(), zzall2);
        zzi2.zzl(this.zzky().zzlU());
        zzi2.zzjt();
    }

    private final void zzlh() {
        this.zzkD();
        zzl.zzjC();
        this.zzagE = true;
        this.zzagy.disconnect();
        this.zzld();
    }

    static /* synthetic */ void zza(zzamv zzamv2) {
        zzamv2.zzkY();
    }

    static /* synthetic */ void zzb(zzamv zzamv2) {
        zzamv2.zzkZ();
    }
}

