/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.internal.zzaol;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzdjx;
    private final Tracker zzdjy;
    private final Context mContext;
    private ExceptionParser zzdjz;
    private GoogleAnalytics zzdka;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzdjx = uncaughtExceptionHandler;
        this.zzdjy = tracker;
        this.zzdjz = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzaol.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzdjz;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzdjz = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzdjz != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzdjz.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzaol.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzdjy.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        ExceptionReporter exceptionReporter = this;
        if (exceptionReporter.zzdka == null) {
            exceptionReporter.zzdka = GoogleAnalytics.getInstance(exceptionReporter.mContext);
        }
        object = exceptionReporter.zzdka;
        ((GoogleAnalytics)object).dispatchLocalHits();
        Object object2 = object;
        ((zza)object2).zztn().zzvz().zzvq();
        if (this.zzdjx != null) {
            zzaol.v("Passing exception to the original handler");
            this.zzdjx.uncaughtException(thread, throwable);
        }
    }

    final Thread.UncaughtExceptionHandler zzts() {
        return this.zzdjx;
    }
}

