/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzaok;
import com.google.android.gms.internal.zzaom;
import com.google.android.gms.internal.zzapb;
import com.google.android.gms.internal.zzapc;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzamr {
    private boolean zzdln;
    private final Map<String, String> zzbqo = new HashMap<String, String>();
    private final Map<String, String> zzdlo = new HashMap<String, String>();
    private final zzaok zzdlp;
    private final zza zzdlq;
    private ExceptionReporter zzdlr;
    private zzapb zzdls;

    Tracker(zzamt zzamt2, String string, zzaok zzaok2) {
        super(zzamt2);
        if (string != null) {
            this.zzbqo.put("&tid", string);
        }
        this.zzbqo.put("useSecure", "1");
        this.zzbqo.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzdlp = new zzaok("tracking", this.zzvu());
        this.zzdlq = new zza(this, zzamt2);
    }

    @Override
    protected final void zzuh() {
        String string;
        this.zzdlq.initialize();
        String string2 = this.zzwb().zzuk();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzwb().zzul()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzapb zzapb2) {
        String string;
        this.zzdn("Loading Tracker config values");
        this.zzdls = zzapb2;
        if (this.zzdls.zzdjn != null) {
            string = this.zzdls.zzdjn;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzdls.zzduh >= 0.0) {
            string = Double.toString(this.zzdls.zzduh);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzdls.zzdui >= 0) {
            int n = this.zzdls.zzdui;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzdls.zzduj != -1) {
            boolean bl = this.zzdls.zzduj == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzdls.zzduk != -1) {
            boolean bl = this.zzdls.zzduk == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzdls.zzdul == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzdlr != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzdlr = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzdlr);
                this.zzdn("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzdlr.zzts());
                this.zzdn("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzdlq.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzdlq.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        Map.Entry<String, String> entry2 = entry;
        String string = entry2.getKey();
        entry2.getValue();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbp.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbp.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzvu().currentTimeMillis();
        if (this.zzvy().getAppOptOut()) {
            this.zzdo("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzvy().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzbqo, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzapc.zze(this.zzbqo.get("useSecure"), true);
        Tracker.zzc(this.zzdlo, hashMap);
        this.zzdlo.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzvv().zze(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzvv().zze(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzdln;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzbqo.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzbqo.put("&a", Integer.toString(n));
            }
        }
        this.zzvx().zzc(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzbqo.containsKey(string)) {
            return this.zzbqo.get(string);
        }
        if (string.equals("&ul")) {
            return zzapc.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzwd().zzxm();
        }
        if (string.equals("&sr")) {
            return this.zzwg().zzyf();
        }
        if (string.equals("&aid")) {
            return this.zzwf().zzxa().getAppId();
        }
        if (string.equals("&an")) {
            return this.zzwf().zzxa().zzuk();
        }
        if (string.equals("&av")) {
            return this.zzwf().zzxa().zzul();
        }
        if (string.equals("&aiid")) {
            return this.zzwf().zzxa().zzum();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbp.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzbqo.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzapc.zzaj(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzdq("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzapc.zzaj(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzdlo.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzdlo.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzdlo.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzdlo.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzdlo.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzdlo.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzdlo.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzdlo.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzdlo.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzdlo.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzdln = bl;
    }

    static /* synthetic */ zzamh zzb(Tracker tracker) {
        return tracker.zzwe();
    }

    static /* synthetic */ zzane zzc(Tracker tracker) {
        return tracker.zzwf();
    }

    static /* synthetic */ zzany zzd(Tracker tracker) {
        return tracker.zzwg();
    }

    static /* synthetic */ zzany zze(Tracker tracker) {
        return tracker.zzwg();
    }

    static /* synthetic */ zzaok zzf(Tracker tracker) {
        return tracker.zzdlp;
    }

    static /* synthetic */ zzaom zzg(Tracker tracker) {
        return tracker.zzvv();
    }

    static /* synthetic */ zzaom zzh(Tracker tracker) {
        return tracker.zzvv();
    }

    static /* synthetic */ zzami zzi(Tracker tracker) {
        return tracker.zzvz();
    }

    static /* synthetic */ zzami zzj(Tracker tracker) {
        return tracker.zzvz();
    }

    final class zza
    extends zzamr
    implements GoogleAnalytics.zza {
        private boolean zzdmb;
        private int zzdmc;
        private long zzdmd;
        private boolean zzdme;
        private long zzdmf;
        private /* synthetic */ Tracker zzdma;

        protected zza(Tracker tracker, zzamt zzamt2) {
            this.zzdma = tracker;
            super(zzamt2);
            this.zzdmd = -1L;
        }

        @Override
        protected final void zzuh() {
        }

        public final void setSessionTimeout(long l) {
            this.zzdmd = l;
            this.zzuj();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzdmb = bl;
            this.zzuj();
        }

        public final synchronized boolean zzui() {
            boolean bl = this.zzdme;
            this.zzdme = false;
            return bl;
        }

        private final void zzuj() {
            if (this.zzdmd >= 0L || this.zzdmb) {
                this.zzvy().zza(this.zzdma.zzdlq);
                return;
            }
            this.zzvy().zzb(this.zzdma.zzdlq);
        }

        @Override
        public final void zzl(Activity activity) {
            zza zza2;
            if (this.zzdmc == 0 && (zza2 = this).zzvu().elapsedRealtime() >= zza2.zzdmf + Math.max(1000L, zza2.zzdmd)) {
                this.zzdme = true;
            }
            ++this.zzdmc;
            if (this.zzdmb) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzdma.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzdma.set("&cd", this.zzdma.zzdls != null ? ((string2 = ((Tracker)this.zzdma).zzdls.zzdum.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbp.zzu((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzdma.send(hashMap);
            }
        }

        @Override
        public final void zzm(Activity activity) {
            --this.zzdmc;
            this.zzdmc = Math.max(0, this.zzdmc);
            if (this.zzdmc == 0) {
                this.zzdmf = this.zzvu().elapsedRealtime();
            }
        }
    }
}

