/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzano;
import com.google.android.gms.internal.zzanu;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzaoc;
import com.google.android.gms.internal.zzaoh;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaoy;
import java.util.Collections;
import java.util.List;

public final class zzamx
extends zzamr {
    private final zzamz zzdpf;
    private zzaoi zzdpg;
    private final zzanw zzdph;
    private zzaoy zzdpi;

    protected zzamx(zzamt zzamt2) {
        super(zzamt2);
        this.zzdpi = new zzaoy(zzamt2.zzvu());
        this.zzdpf = new zzamz(this);
        this.zzdph = new zzamy(this, zzamt2);
    }

    @Override
    protected final void zzuh() {
    }

    public final boolean isConnected() {
        zzl.zzug();
        this.zzwh();
        return this.zzdpg != null;
    }

    public final boolean zzb(zzaoh zzaoh2) {
        zzbp.zzu((Object)zzaoh2);
        zzl.zzug();
        this.zzwh();
        zzaoi zzaoi2 = this.zzdpg;
        if (zzaoi2 == null) {
            return false;
        }
        String string = zzaoh2.zzym() ? zzanu.zzxy() : zzanu.zzxz();
        List<zzano> list = Collections.emptyList();
        try {
            zzaoi2.zza(zzaoh2.zzix(), zzaoh2.zzyk(), string, list);
            this.zzwt();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzdn("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzws() {
        zzl.zzug();
        this.zzwh();
        zzaoi zzaoi2 = this.zzdpg;
        if (zzaoi2 == null) {
            return false;
        }
        try {
            zzaoi2.zzvo();
            this.zzwt();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzdn("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzwt() {
        this.zzdpi.start();
        this.zzdph.zzs(zzaoc.zzdsn.get());
    }

    public final boolean connect() {
        zzl.zzug();
        this.zzwh();
        if (this.zzdpg != null) {
            return true;
        }
        zzaoi zzaoi2 = this.zzdpf.zzwv();
        if (zzaoi2 != null) {
            this.zzdpg = zzaoi2;
            this.zzwt();
            return true;
        }
        return false;
    }

    private final void zza(zzaoi zzaoi2) {
        zzl.zzug();
        this.zzdpg = zzaoi2;
        this.zzwt();
        this.zzvz().onServiceConnected();
    }

    public final void disconnect() {
        zzl.zzug();
        this.zzwh();
        try {
            zza.zzaky();
            zzamz zzamz2 = this.zzdpf;
            Context context = this.getContext();
            context.unbindService((ServiceConnection)zzamz2);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzdpg != null) {
            this.zzdpg = null;
            this.zzvz().zzvr();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzl.zzug();
        if (this.zzdpg != null) {
            this.zzdpg = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzvz().zzvr();
        }
    }

    private final void zzwu() {
        zzl.zzug();
        if (!this.isConnected()) {
            return;
        }
        this.zzdn("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzamz zza(zzamx zzamx2) {
        return zzamx2.zzdpf;
    }

    static /* synthetic */ void zza(zzamx zzamx2, zzaoi zzaoi2) {
        zzamx2.zza(zzaoi2);
    }

    static /* synthetic */ void zza(zzamx zzamx2, ComponentName componentName) {
        zzamx2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzamx zzamx2) {
        zzamx2.zzwu();
    }
}

