/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzapc;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzl {
    private static volatile zzl zzdlc;
    private final Context mContext;
    private final List<Object> zzdld;
    private final zzg zzdle;
    private final zza zzdlf;
    private volatile zzalu zzdlg;
    private Thread.UncaughtExceptionHandler zzdlh;

    private zzl(Context context) {
        Context context2 = context.getApplicationContext();
        zzbp.zzu((Object)context2);
        this.mContext = context2;
        this.zzdlf = new zza();
        this.zzdld = new CopyOnWriteArrayList<Object>();
        this.zzdle = new zzg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzl zzbh(Context context) {
        zzbp.zzu((Object)context);
        if (zzdlc != null) return zzdlc;
        Class<zzl> clazz = zzl.class;
        synchronized (zzl.class) {
            if (zzdlc != null) return zzdlc;
            zzdlc = new zzl(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzdlc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzalu zzue() {
        if (this.zzdlg == null) {
            zzl zzl2 = this;
            synchronized (zzl2) {
                if (this.zzdlg == null) {
                    zzalu zzalu2 = new zzalu();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzalu2.setAppId(string);
                    zzalu2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzalu2.setAppName(string2);
                    zzalu2.setAppVersion(string3);
                    this.zzdlg = zzalu2;
                }
            }
        }
        return this.zzdlg;
    }

    public final zzalz zzuf() {
        int n;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzalz zzalz2 = new zzalz();
        zzalz2.setLanguage(zzapc.zza(Locale.getDefault()));
        zzalz2.zzcer = n = displayMetrics.widthPixels;
        zzalz2.zzces = n = displayMetrics.heightPixels;
        return zzalz2;
    }

    final void zze(zzi zzi2) {
        if (zzi2.zzub()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzi2.zzty()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzi zzi3 = zzi2.zztu();
        zzi3.zztz();
        this.zzdlf.execute(new zzm(this, zzi3));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public static void zzug() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzdlh = uncaughtExceptionHandler;
    }

    public final <V> Future<V> zzc(Callable<V> callable) {
        zzbp.zzu(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzdlf.submit(callable);
    }

    public final void zzc(Runnable runnable) {
        zzbp.zzu((Object)runnable);
        this.zzdlf.submit(runnable);
    }

    private static void zzb(zzi zzi2) {
        zzbp.zzgg((String)"deliver should be called from worker thread");
        zzbp.zzb((boolean)zzi2.zzty(), (Object)"Measurement must be submitted");
        List<zzo> list = zzi2.getTransports();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzo zzo2 : list) {
            Uri uri = zzo2.zztq();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzo2.zzb(zzi2);
        }
    }

    static /* synthetic */ List zza(zzl zzl2) {
        return zzl2.zzdld;
    }

    static /* synthetic */ void zza(zzl zzl2, zzi zzi2) {
        zzl.zzb(zzi2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzl zzl2) {
        return zzl2.zzdlh;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzdll = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zzdll.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzm zzm2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzn(this, runnable, t);
        }
    }
}

