/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaog;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzapw;
import com.google.android.gms.internal.zzaqi;
import com.google.android.gms.internal.zzaqk;
import com.google.android.gms.internal.zzaqz;
import com.google.android.gms.internal.zzara;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzaop {
    private boolean zzdni;
    private final Map<String, String> zzbqw = new HashMap<String, String>();
    private final Map<String, String> zzdnj = new HashMap<String, String>();
    private final zzaqi zzdnk;
    private final zza zzdnl;
    private ExceptionReporter zzdnm;
    private zzaqz zzdnn;

    Tracker(zzaor zzaor2, String string, zzaqi zzaqi2) {
        super(zzaor2);
        if (string != null) {
            this.zzbqw.put("&tid", string);
        }
        this.zzbqw.put("useSecure", "1");
        this.zzbqw.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzdnk = new zzaqi("tracking", this.zzwh());
        this.zzdnl = new zza(this, zzaor2);
    }

    @Override
    protected final void zzuu() {
        String string;
        this.zzdnl.initialize();
        String string2 = this.zzwo().zzux();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzwo().zzuy()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzaqz zzaqz2) {
        String string;
        this.zzdn("Loading Tracker config values");
        this.zzdnn = zzaqz2;
        if (this.zzdnn.zzdlo != null) {
            string = this.zzdnn.zzdlo;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzdnn.zzdwf >= 0.0) {
            string = Double.toString(this.zzdnn.zzdwf);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzdnn.zzdwg >= 0) {
            int n = this.zzdnn.zzdwg;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzdnn.zzdwh != -1) {
            boolean bl = this.zzdnn.zzdwh == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzdnn.zzdwi != -1) {
            boolean bl = this.zzdnn.zzdwi == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzdnn.zzdwj == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzdnm != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzdnm = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzdnm);
                this.zzdn("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzdnm.zzuf());
                this.zzdn("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzdnl.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzdnl.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbq.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbq.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzwh().currentTimeMillis();
        if (this.zzwl().getAppOptOut()) {
            this.zzdo("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzwl().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzbqw, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzara.zzd(this.zzbqw.get("useSecure"), true);
        Tracker.zzc(this.zzdnj, hashMap);
        this.zzdnj.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzwi().zzf(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzwi().zzf(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzdni;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzbqw.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzbqw.put("&a", Integer.toString(n));
            }
        }
        this.zzwk().zzc(new zzn(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzbqw.containsKey(string)) {
            return this.zzbqw.get(string);
        }
        if (string.equals("&ul")) {
            return zzara.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzwq().zzxz();
        }
        if (string.equals("&sr")) {
            return this.zzwt().zzys();
        }
        if (string.equals("&aid")) {
            return this.zzws().zzxn().getAppId();
        }
        if (string.equals("&an")) {
            return this.zzws().zzxn().zzux();
        }
        if (string.equals("&av")) {
            return this.zzws().zzxn().zzuy();
        }
        if (string.equals("&aiid")) {
            return this.zzws().zzxn().zzuz();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbq.checkNotNull((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzbqw.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzara.zzaj(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzdq("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzara.zzaj(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzdnj.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzdnj.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzdnj.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzdnj.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzdnj.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzdnj.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzdnj.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzdnj.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzdnj.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzdnj.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzdni = bl;
    }

    static /* synthetic */ zzaof zzb(Tracker tracker) {
        return tracker.zzwr();
    }

    static /* synthetic */ zzapc zzc(Tracker tracker) {
        return tracker.zzws();
    }

    static /* synthetic */ zzapw zzd(Tracker tracker) {
        return tracker.zzwt();
    }

    static /* synthetic */ zzapw zze(Tracker tracker) {
        return tracker.zzwt();
    }

    static /* synthetic */ zzaqi zzf(Tracker tracker) {
        return tracker.zzdnk;
    }

    static /* synthetic */ zzaqk zzg(Tracker tracker) {
        return tracker.zzwi();
    }

    static /* synthetic */ zzaqk zzh(Tracker tracker) {
        return tracker.zzwi();
    }

    static /* synthetic */ zzaog zzi(Tracker tracker) {
        return tracker.zzwm();
    }

    static /* synthetic */ zzaog zzj(Tracker tracker) {
        return tracker.zzwm();
    }

    final class zza
    extends zzaop
    implements GoogleAnalytics.zza {
        private boolean zzdnw;
        private int zzdnx;
        private long zzdny;
        private boolean zzdnz;
        private long zzdoa;
        private /* synthetic */ Tracker zzdnv;

        protected zza(Tracker tracker, zzaor zzaor2) {
            this.zzdnv = tracker;
            super(zzaor2);
            this.zzdny = -1L;
        }

        @Override
        protected final void zzuu() {
        }

        public final void setSessionTimeout(long l) {
            this.zzdny = l;
            this.zzuw();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzdnw = bl;
            this.zzuw();
        }

        public final synchronized boolean zzuv() {
            boolean bl = this.zzdnz;
            this.zzdnz = false;
            return bl;
        }

        private final void zzuw() {
            if (this.zzdny >= 0L || this.zzdnw) {
                this.zzwl().zza(this.zzdnv.zzdnl);
                return;
            }
            this.zzwl().zzb(this.zzdnv.zzdnl);
        }

        @Override
        public final void zzl(Activity activity) {
            zza zza2;
            if (this.zzdnx == 0 && (zza2 = this).zzwh().elapsedRealtime() >= zza2.zzdoa + Math.max(1000L, zza2.zzdny)) {
                this.zzdnz = true;
            }
            ++this.zzdnx;
            if (this.zzdnw) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzdnv.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzdnv.set("&cd", this.zzdnv.zzdnn != null ? ((string2 = ((Tracker)this.zzdnv).zzdnn.zzdwk.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbq.checkNotNull((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzdnv.send(hashMap);
            }
        }

        @Override
        public final void zzm(Activity activity) {
            --this.zzdnx;
            this.zzdnx = Math.max(0, this.zzdnx);
            if (this.zzdnx == 0) {
                this.zzdoa = this.zzwh().elapsedRealtime();
            }
        }
    }
}

