/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanu;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaob;
import com.google.android.gms.internal.zzaoc;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoe;
import com.google.android.gms.internal.zzaoo;
import com.google.android.gms.internal.zzaoq;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzara;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzaoo
implements zzm {
    private static DecimalFormat zzdln;
    private final zzaor zzdlj;
    private final String zzdlo;
    private final Uri zzdlp;

    public zzb(zzaor zzaor2, String string) {
        this(zzaor2, string, true, false);
    }

    private zzb(zzaor zzaor2, String string, boolean bl, boolean bl2) {
        super(zzaor2);
        zzbq.zzgh((String)string);
        this.zzdlj = zzaor2;
        this.zzdlo = string;
        this.zzdlp = zzb.zzcy(this.zzdlo);
    }

    static Uri zzcy(String string) {
        zzbq.zzgh((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzue() {
        return this.zzdlp;
    }

    @Override
    public final void zzb(zzg zzg2) {
        zzbq.checkNotNull((Object)zzg2);
        zzbq.checkArgument((boolean)zzg2.zzul(), (Object)"Can't deliver not submitted measurement");
        zzbq.zzgi((String)"deliver should be called on worker thread");
        zzg zzg3 = zzg2.zzuh();
        zzaob zzaob2 = zzg3.zzb(zzaob.class);
        if (TextUtils.isEmpty((CharSequence)zzaob2.zzvn())) {
            this.zzwi().zzf(zzb.zzc(zzg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzaob2.zzvo())) {
            this.zzwi().zzf(zzb.zzc(zzg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzdlj.zzwx().getAppOptOut()) {
            return;
        }
        double d = zzaob2.zzvt();
        if (zzara.zza(d, zzaob2.zzvo())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzg3);
        map.put("v", "1");
        map.put("_v", zzaoq.zzdqe);
        map.put("tid", this.zzdlo);
        if (this.zzdlj.zzwx().isDryRunEnabled()) {
            Map<String, String> map2 = map;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzara.zzb(hashMap, "uid", zzaob2.getUserId());
        zzans zzans2 = zzg2.zza(zzans.class);
        if (zzans2 != null) {
            zzara.zzb(hashMap, "an", zzans2.zzux());
            zzara.zzb(hashMap, "aid", zzans2.getAppId());
            zzara.zzb(hashMap, "av", zzans2.zzuy());
            zzara.zzb(hashMap, "aiid", zzans2.zzuz());
        }
        zzaou zzaou2 = new zzaou(0L, zzaob2.zzvo(), this.zzdlo, !TextUtils.isEmpty((CharSequence)zzaob2.zzvp()), 0L, hashMap);
        long l = this.zzwm().zza(zzaou2);
        map.put("_s", String.valueOf(l));
        zzaqf zzaqf2 = new zzaqf(this.zzwi(), map, zzg2.zzuj(), true);
        this.zzwm().zza(zzaqf2);
    }

    private static Map<String, String> zzc(zzg zzg2) {
        zzans zzans2;
        zzanv zzanv2;
        Object object;
        Object object2;
        Object object3;
        zzanu zzanu2;
        zzaoe zzaoe2;
        zzaod zzaod2;
        zzaoa zzaoa2;
        zzant zzant2;
        zzanz zzanz2;
        Object object4;
        Object object5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzanw zzanw2 = zzg2.zza(zzanw.class);
        if (zzanw2 != null) {
            object5 = zzanw2.zzvi().entrySet().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (Map.Entry)object5.next();
                Object v = object4.getValue();
                if ((v == null ? null : (v instanceof String ? (!TextUtils.isEmpty((CharSequence)(object6 = (String)v)) ? object6 : null) : (v instanceof Double ? ((Double)(object6 = (Double)v) != 0.0 ? zzb.zzb((Double)object6) : null) : (v instanceof Boolean ? (v != Boolean.FALSE ? "1" : null) : (zzanz2 = String.valueOf(v)))))) == null) continue;
                hashMap.put((String)object4.getKey(), (String)((Object)zzanz2));
            }
        }
        if ((object5 = zzg2.zza(zzaob.class)) != null) {
            zzb.zza(hashMap, "t", ((zzaob)object5).zzvn());
            zzb.zza(hashMap, "cid", ((zzaob)object5).zzvo());
            zzb.zza(hashMap, "uid", ((zzaob)object5).getUserId());
            zzb.zza(hashMap, "sc", ((zzaob)object5).zzvr());
            zzb.zza(hashMap, "sf", ((zzaob)object5).zzvt());
            zzb.zza(hashMap, "ni", ((zzaob)object5).zzvs());
            zzb.zza(hashMap, "adid", ((zzaob)object5).zzvp());
            zzb.zza(hashMap, "ate", ((zzaob)object5).zzvq());
        }
        if ((object4 = zzg2.zza(zzaoc.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzaoc)object4).zzvu());
            zzb.zza(hashMap, "a", ((zzaoc)object4).zzvv());
            zzb.zza(hashMap, "dr", ((zzaoc)object4).zzvw());
        }
        if ((zzanz2 = zzg2.zza(zzanz.class)) != null) {
            zzb.zza(hashMap, "ec", zzanz2.getCategory());
            zzb.zza(hashMap, "ea", zzanz2.getAction());
            zzb.zza(hashMap, "el", zzanz2.getLabel());
            zzb.zza(hashMap, "ev", zzanz2.getValue());
        }
        if ((zzant2 = zzg2.zza(zzant.class)) != null) {
            zzb.zza(hashMap, "cn", zzant2.getName());
            zzb.zza(hashMap, "cs", zzant2.getSource());
            zzb.zza(hashMap, "cm", zzant2.zzva());
            zzb.zza(hashMap, "ck", zzant2.zzvb());
            zzb.zza(hashMap, "cc", zzant2.getContent());
            zzb.zza(hashMap, "ci", zzant2.getId());
            zzb.zza(hashMap, "anid", zzant2.zzvc());
            zzb.zza(hashMap, "gclid", zzant2.zzvd());
            zzb.zza(hashMap, "dclid", zzant2.zzve());
            zzb.zza(hashMap, "aclid", zzant2.zzvf());
        }
        if ((zzaoa2 = zzg2.zza(zzaoa.class)) != null) {
            zzb.zza(hashMap, "exd", zzaoa2.zzdou);
            zzb.zza(hashMap, "exf", zzaoa2.zzdov);
        }
        if ((zzaod2 = zzg2.zza(zzaod.class)) != null) {
            zzb.zza(hashMap, "sn", zzaod2.zzdpj);
            zzb.zza(hashMap, "sa", zzaod2.zzdor);
            zzb.zza(hashMap, "st", zzaod2.zzdpk);
        }
        if ((zzaoe2 = zzg2.zza(zzaoe.class)) != null) {
            zzb.zza(hashMap, "utv", zzaoe2.zzdpl);
            zzb.zza(hashMap, "utt", zzaoe2.zzdpm);
            zzb.zza(hashMap, "utc", zzaoe2.mCategory);
            zzb.zza(hashMap, "utl", zzaoe2.zzdos);
        }
        if ((zzanu2 = zzg2.zza(zzanu.class)) != null) {
            object3 = zzanu2.zzvg().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = zzd.zzaj(object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((zzanv2 = zzg2.zza(zzanv.class)) != null) {
            object2 = zzanv2.zzvh().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = zzd.zzal((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzg2.zza(zzany.class)) != null) {
            object2 = ((zzany)object3).zzvj();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzany)object3).zzvm()) {
                hashMap.putAll(promotion.zzdk(zzd.zzap(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzany)object3).zzvk()) {
                hashMap.putAll(product.zzdk(zzd.zzan(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzany)object3).zzvl().entrySet()) {
                List<Product> list = entry.getValue();
                String string = zzd.zzas(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzaq(n2));
                    hashMap.putAll(product.zzdk(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzg2.zza(zzanx.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzanx)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzanx)object2).zzdoo);
            zzb.zza(hashMap, "sr", ((zzanx)object2).zzcfw, ((zzanx)object2).zzcfx);
            zzb.zza(hashMap, "vp", ((zzanx)object2).zzdop, ((zzanx)object2).zzdoq);
        }
        if ((zzans2 = zzg2.zza(zzans.class)) != null) {
            zzb.zza(hashMap, "an", zzans2.zzux());
            zzb.zza(hashMap, "aid", zzans2.getAppId());
            zzb.zza(hashMap, "aiid", zzans2.zzuz());
            zzb.zza(hashMap, "av", zzans2.zzuy());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    private static String zzb(double d) {
        if (zzdln == null) {
            zzdln = new DecimalFormat("0.######");
        }
        return zzdln.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }
}

