/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaqw;
import com.google.android.gms.internal.zzara;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public final class zzaof
extends zzaop {
    private static boolean zzdpo;
    private AdvertisingIdClient.Info zzdpp;
    private final zzaqw zzdpq;
    private String zzdpr;
    private boolean zzdps = false;
    private final Object zzdpt = new Object();

    zzaof(zzaor zzaor2) {
        super(zzaor2);
        this.zzdpq = new zzaqw(zzaor2.zzwh());
    }

    @Override
    protected final void zzuu() {
    }

    public final boolean zzvq() {
        this.zzwu();
        AdvertisingIdClient.Info info = this.zzvy();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzvx() {
        this.zzwu();
        AdvertisingIdClient.Info info = this.zzvy();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzvy() {
        if (this.zzdpq.zzt(1000L)) {
            this.zzdpq.start();
            AdvertisingIdClient.Info info = this.zzvz();
            if (this.zza(this.zzdpp, info)) {
                this.zzdpp = info;
            } else {
                this.zzdr("Failed to reset client id on adid change. Not using adid");
                this.zzdpp = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzdpp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzwq().zzxz();
        Object object = this.zzdpt;
        synchronized (object) {
            String string3;
            if (!this.zzdps) {
                this.zzdpr = this.zzwa();
                this.zzdps = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzdpr)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzdm(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzdpr = zzaof.zzdl(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzaof.zzdl(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzdpr)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdpr)) {
                this.zzdn("Resetting the client id because Advertising Id changed.");
                string2 = this.zzwq().zzya();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzdm(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzvz() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzdq("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzdpo) break block3;
                zzdpo = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzdl(String string) {
        MessageDigest messageDigest = zzara.zzed("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzdm(String string) {
        try {
            String string2 = zzaof.zzdl(string);
            this.zzdn("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzdpr = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzwa() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzdq("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzdn("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

