/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzapd;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzaph;
import com.google.android.gms.internal.zzapm;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqc;
import com.google.android.gms.internal.zzaqe;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzaqg;
import com.google.android.gms.internal.zzaql;
import com.google.android.gms.internal.zzaqp;
import com.google.android.gms.internal.zzaqq;
import com.google.android.gms.internal.zzaqr;
import com.google.android.gms.internal.zzaqs;
import com.google.android.gms.internal.zzard;
import com.google.android.gms.internal.zzarf;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzarj;
import com.google.android.gms.internal.zzarl;
import com.google.android.gms.internal.zzarq;
import com.google.android.gms.internal.zzarw;
import com.google.android.gms.internal.zzarx;
import com.google.android.gms.internal.zzasc;
import com.google.android.gms.internal.zzasd;
import com.google.android.gms.internal.zzash;
import com.google.android.gms.internal.zzasl;
import com.google.android.gms.internal.zzasm;
import com.google.android.gms.internal.zzbhf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzaqo
extends zzaqa {
    private boolean mStarted;
    private final zzaql zzdum;
    private final zzarx zzdun;
    private final zzarw zzduo;
    private final zzaqg zzdup;
    private long zzduq;
    private final zzarf zzdur;
    private final zzarf zzdus;
    private final zzash zzdut;
    private long zzduu;
    private boolean zzduv;

    protected zzaqo(zzaqc zzaqc2, zzaqe zzaqe2) {
        super(zzaqc2);
        zzbq.checkNotNull((Object)zzaqe2);
        this.zzduq = Long.MIN_VALUE;
        zzaqc zzaqc3 = zzaqc2;
        this.zzduo = new zzarw(zzaqc3);
        zzaqc3 = zzaqc2;
        this.zzdum = new zzaql(zzaqc3);
        zzaqc3 = zzaqc2;
        this.zzdun = new zzarx(zzaqc3);
        zzaqc3 = zzaqc2;
        this.zzdup = new zzaqg(zzaqc3);
        this.zzdut = new zzash(this.zzws());
        this.zzdur = new zzaqp(this, zzaqc2);
        this.zzdus = new zzaqq(this, zzaqc2);
    }

    @Override
    protected final void zzvf() {
        this.zzdum.initialize();
        this.zzdun.initialize();
        this.zzdup.initialize();
    }

    final void start() {
        this.zzxf();
        zzbq.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzwv().zzc(new zzaqr(this));
    }

    private final boolean zzeb(String string) {
        return zzbhf.zzdb((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzxz() {
        this.zzxf();
        zzaqo zzaqo2 = this;
        zzj.zzve();
        Context context = zzaqo2.zzwr().getContext();
        if (!zzasc.zzbk(context)) {
            zzaqo2.zzdx("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzasd.zzbo(context)) {
            zzaqo2.zzdy("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzbk(context)) {
            zzaqo2.zzdx("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzxa().zzzw();
        if (!this.zzeb("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzdy("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzyj();
        }
        if (!this.zzeb("android.permission.INTERNET")) {
            this.zzdy("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzyj();
        }
        if (zzasd.zzbo(this.getContext())) {
            this.zzdu("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzdx("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzduv && !this.zzdum.isEmpty()) {
            this.zzyc();
        }
        this.zzyf();
    }

    private final void zzya() {
        this.zzb(new zzaqs(this));
    }

    final void zzwq() {
        zzj.zzve();
        this.zzduu = this.zzws().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzj.zzve();
        zzaqo zzaqo2 = this;
        zzj.zzve();
        zzaqo2.zzxf();
        if (!zzard.zzyq()) {
            zzaqo2.zzdx("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzaqo2.zzdup.isConnected()) {
            zzaqo2.zzdu("Service not connected");
            return;
        }
        if (!zzaqo2.zzdum.isEmpty()) {
            zzaqo2.zzdu("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzarq> list;
                try {
                    list = zzaqo2.zzdum.zzo(zzard.zzyu());
                    if (list.isEmpty()) {
                        zzaqo2.zzyf();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzaqo2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzaqo2.zzyh();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzarq zzarq2 = list.get(0);
                    if (!zzaqo2.zzdup.zzb(zzarq2)) {
                        zzaqo2.zzyf();
                        return;
                    }
                    list.remove(zzarq2);
                    try {
                        zzaqo2.zzdum.zzp(zzarq2.zzzh());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzaqo2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzaqo2.zzyh();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzyb() {
        try {
            this.zzdum.zzxu();
            this.zzyf();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzdus.zzs(86400000L);
    }

    protected final void zzb(zzaqf zzaqf2) {
        zzj.zzve();
        this.zzb("Sending first hit to property", zzaqf2.zzxn());
        if (this.zzxa().zzzx().zzu(zzard.zzza())) {
            return;
        }
        String string = this.zzxa().zzaaa();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzape zzape2 = zzasl.zza(this.zzwt(), string);
        this.zzb("Found relevant installation campaign", zzape2);
        this.zza(zzaqf2, zzape2);
    }

    public final void zzr(long l) {
        zzj.zzve();
        this.zzxf();
        if (l < 0L) {
            l = 0L;
        }
        this.zzduq = l;
        this.zzyf();
    }

    private final void zzyc() {
        if (this.zzduv) {
            return;
        }
        if (!zzard.zzyq()) {
            return;
        }
        if (this.zzdup.isConnected()) {
            return;
        }
        long l = zzarl.zzdxk.get();
        if (this.zzdut.zzu(l)) {
            this.zzdut.start();
            this.zzdu("Connecting to service");
            if (this.zzdup.connect()) {
                this.zzdu("Connected to service");
                this.zzdut.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzaqf zzaqf2, boolean bl) {
        long l;
        zzbq.checkNotNull((Object)zzaqf2);
        this.zzxf();
        zzj.zzve();
        try {
            this.zzdum.beginTransaction();
            String string = zzaqf2.zzvz();
            long l2 = zzaqf2.zzxm();
            zzaql zzaql2 = this.zzdum;
            zzbq.zzgm((String)string);
            zzaql2.zzxf();
            zzj.zzve();
            int n = zzaql2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzaql2.zza("Deleted property records", n);
            }
            l = this.zzdum.zza(zzaqf2.zzxm(), zzaqf2.zzvz(), zzaqf2.zzxn());
            zzaqf2.zzm(l + 1L);
            zzaqf zzaqf3 = zzaqf2;
            zzaql zzaql3 = this.zzdum;
            zzbq.checkNotNull((Object)zzaqf3);
            zzaql3.zzxf();
            zzj.zzve();
            SQLiteDatabase sQLiteDatabase = zzaql3.getWritableDatabase();
            Map<String, String> map = zzaqf3.zzjh();
            zzbq.checkNotNull(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzaqf3.zzxm()));
            contentValues.put("cid", zzaqf3.zzvz());
            contentValues.put("tid", zzaqf3.zzxn());
            contentValues.put("adid", Integer.valueOf(zzaqf3.zzxo() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzaqf3.zzxp()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzaql3.zzdy("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzaql3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzdum.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzdum.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzarq zzarq2) {
        zzarq zzarq3;
        zzbq.checkNotNull((Object)zzarq2);
        zzj.zzve();
        this.zzxf();
        if (this.zzduv) {
            this.zzdv("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzarq2);
        }
        zzarq zzarq4 = zzarq2;
        zzaqo zzaqo2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzarq4.zzzm())) {
            zzarq3 = zzarq4;
        } else {
            Pair<String, Long> pair = zzaqo2.zzxa().zzaab().zzaad();
            if (pair == null) {
                zzarq3 = zzarq4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzarq4.zzjh());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzarq zzarq5 = zzarq4;
                zzaqo zzaqo3 = zzaqo2;
                zzarq3 = new zzarq(zzaqo3, (Map<String, String>)object2, zzarq5.zzzi(), zzarq5.zzzk(), zzarq5.zzzh(), zzarq5.zzzg(), zzarq5.zzzj());
            }
        }
        zzarq2 = zzarq3;
        this.zzyc();
        if (this.zzdup.zzb(zzarq2)) {
            this.zzdv("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzdum.zzc(zzarq2);
            this.zzyf();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzwt().zza(zzarq2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzwm() {
        zzj.zzve();
        this.zzxf();
        this.zzdu("Delete all hits from local store");
        try {
            zzaql zzaql2 = this.zzdum;
            zzj.zzve();
            zzaql2.zzxf();
            zzaql2.getWritableDatabase().delete("hits2", null, null);
            zzaql2 = this.zzdum;
            zzj.zzve();
            zzaql2.zzxf();
            zzaql2.getWritableDatabase().delete("properties", null, null);
            this.zzyf();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzyc();
        if (this.zzdup.zzxq()) {
            this.zzdu("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzyd() {
        boolean bl;
        zzj.zzve();
        this.zzxf();
        this.zzdu("Dispatching a batch of local hits");
        boolean bl2 = !this.zzdup.isConnected();
        boolean bl3 = bl = !this.zzdun.zzzs();
        if (bl2 && bl) {
            this.zzdu("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzard.zzyu(), zzard.zzyv());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzarq> list;
                block38: {
                    this.zzdum.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzdum.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzdu("Store is empty, nothing to dispatch");
                        this.zzyh();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzyh();
                        try {
                            this.zzdum.setTransactionSuccessful();
                            this.zzdum.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzyh();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzzh() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzyh();
                    return false;
                }
                if (this.zzdup.isConnected()) {
                    this.zzdu("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzdup.zzb((zzarq)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzarq)((Object)list2)).zzzh());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzdum.zzp(((zzarq)((Object)list2)).zzzh());
                            arrayList.add(((zzarq)((Object)list2)).zzzh());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzyh();
                            try {
                                this.zzdum.setTransactionSuccessful();
                                this.zzdum.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzyh();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzdun.zzzs()) {
                    list2 = this.zzdun.zzu(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzdum.zzs(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzyh();
                        try {
                            this.zzdum.setTransactionSuccessful();
                            this.zzdum.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzyh();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzdum.setTransactionSuccessful();
                    this.zzdum.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzyh();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzarj zzarj2) {
        long l = this.zzduu;
        zzarj zzarj3 = zzarj2;
        zzaqo zzaqo2 = this;
        zzj.zzve();
        zzaqo2.zzxf();
        long l2 = -1L;
        long l3 = zzaqo2.zzxa().zzzy();
        if (l3 != 0L) {
            l2 = Math.abs(zzaqo2.zzws().currentTimeMillis() - l3);
        }
        zzaqo2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzaqo2.zzyc();
        try {
            zzaqo2.zzyd();
            zzaqo2.zzxa().zzzz();
            zzaqo2.zzyf();
            if (zzarj3 != null) {
                zzarj3.zzd(null);
            }
            if (zzaqo2.zzduu != l) {
                zzaqo2.zzduo.zzzr();
            }
            return;
        }
        catch (Throwable throwable) {
            zzaqo2.zze("Local dispatch failed", throwable);
            zzaqo2.zzxa().zzzz();
            zzaqo2.zzyf();
            if (zzarj3 != null) {
                zzarj3.zzd(throwable);
            }
            return;
        }
    }

    public final void zzye() {
        zzj.zzve();
        this.zzxf();
        this.zzdv("Sync dispatching local hits");
        long l = this.zzduu;
        this.zzyc();
        try {
            this.zzyd();
            this.zzxa().zzzz();
            this.zzyf();
            if (this.zzduu != l) {
                this.zzduo.zzzr();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzyf();
            return;
        }
    }

    private final long zzxv() {
        zzj.zzve();
        this.zzxf();
        try {
            return this.zzdum.zzxv();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzyf() {
        boolean bl;
        zzj.zzve();
        this.zzxf();
        zzaqo zzaqo2 = this;
        if (!(!zzaqo2.zzduv && zzaqo2.zzyi() > 0L)) {
            this.zzduo.unregister();
            this.zzyh();
            return;
        }
        if (this.zzdum.isEmpty()) {
            this.zzduo.unregister();
            this.zzyh();
            return;
        }
        if (!zzarl.zzdxf.get().booleanValue()) {
            this.zzduo.zzzp();
            bl = this.zzduo.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzaqo2 = this;
            zzaqo2.zzyg();
            long l3 = zzaqo2.zzyi();
            long l4 = zzaqo2.zzxa().zzzy();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzaqo2.zzws().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzard.zzys(), l3)) : Math.min(zzard.zzys(), l3);
            zzaqo2.zza("Dispatch scheduled (ms)", l5);
            if (zzaqo2.zzdur.zzdx()) {
                l = Math.max(1L, l5 + zzaqo2.zzdur.zzzb());
                zzaqo2.zzdur.zzt(l);
                return;
            }
            zzaqo2.zzdur.zzs(l5);
            return;
        }
        this.zzyh();
        this.zzyg();
    }

    private final void zzyg() {
        long l;
        zzari zzari2 = this.zzwy();
        if (!zzari2.zzze()) {
            return;
        }
        if (!zzari2.zzdx() && (l = this.zzxv()) != 0L && Math.abs(this.zzws().currentTimeMillis() - l) <= zzarl.zzdwj.get()) {
            long l2 = zzard.zzyt();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzari2.schedule();
        }
    }

    private final void zzyh() {
        zzaqo zzaqo2 = this;
        if (zzaqo2.zzdur.zzdx()) {
            zzaqo2.zzdu("All hits dispatched or no network/service. Going to power save mode");
        }
        zzaqo2.zzdur.cancel();
        zzari zzari2 = this.zzwy();
        if (zzari2.zzdx()) {
            zzari2.cancel();
        }
    }

    private final long zzyi() {
        if (this.zzduq != Long.MIN_VALUE) {
            return this.zzduq;
        }
        long l = zzarl.zzdwe.get();
        zzasm zzasm2 = this.zzwz();
        zzasm2.zzxf();
        if (zzasm2.zzdzk) {
            zzasm2 = this.zzwz();
            zzasm2.zzxf();
            l = (long)zzasm2.zzdxr * 1000L;
        }
        return l;
    }

    public final void zzec(String string) {
        zzbq.zzgm((String)string);
        zzj.zzve();
        zzape zzape2 = zzasl.zza(this.zzwt(), string);
        if (zzape2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzxa().zzaaa();
        if (string.equals(string2)) {
            this.zzdx("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzxa().zzef(string);
        if (this.zzxa().zzzx().zzu(zzard.zzza())) {
            this.zzd("Campaign received too late, ignoring", zzape2);
            return;
        }
        this.zzb("Received installation campaign", zzape2);
        for (zzaqf zzaqf2 : this.zzdum.zzq(0L)) {
            this.zza(zzaqf2, zzape2);
        }
    }

    private final void zza(zzaqf zzaqf2, zzape zzape2) {
        zzbq.checkNotNull((Object)zzaqf2);
        zzbq.checkNotNull((Object)zzape2);
        zza zza2 = new zza(this.zzwr());
        zza2.zzde(zzaqf2.zzxn());
        zza2.enableAdvertisingIdCollection(zzaqf2.zzxo());
        zzg zzg2 = ((zzi)zza2).zzun();
        zzapm zzapm2 = zzg2.zzb(zzapm.class);
        zzapm2.zzdp("data");
        zzapm2.zzaj(true);
        zzg2.zza(zzape2);
        zzaph zzaph2 = zzg2.zzb(zzaph.class);
        zzapd zzapd2 = zzg2.zzb(zzapd.class);
        for (Map.Entry<String, String> entry : zzaqf2.zzjh().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzapd2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzapd2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzapd2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzapd2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzapm2.setUserId(string2);
                continue;
            }
            zzaph2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzaqf2.zzxn(), zzape2);
        zzg2.zzl(this.zzxa().zzzw());
        zzg2.zzuv();
    }

    private final void zzyj() {
        this.zzxf();
        zzj.zzve();
        this.zzduv = true;
        this.zzdup.disconnect();
        this.zzyf();
    }

    static /* synthetic */ void zza(zzaqo zzaqo2) {
        zzaqo2.zzya();
    }

    static /* synthetic */ void zzb(zzaqo zzaqo2) {
        zzaqo2.zzyb();
    }
}

