/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqc;
import com.google.android.gms.internal.zzaqv;
import com.google.android.gms.internal.zzaqw;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzaqu
extends zzaqa {
    private volatile String zzdrv;
    private Future<String> zzdve;

    protected zzaqu(zzaqc zzaqc2) {
        super(zzaqc2);
    }

    @Override
    protected final void zzvf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzyk() {
        this.zzxf();
        zzaqu zzaqu2 = this;
        synchronized (zzaqu2) {
            if (this.zzdrv == null) {
                this.zzdve = this.zzwv().zza(new zzaqv(this));
            }
            if (this.zzdve != null) {
                try {
                    this.zzdrv = this.zzdve.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzdrv = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzdrv = "0";
                }
                if (this.zzdrv == null) {
                    this.zzdrv = "0";
                }
                this.zza("Loaded clientId", this.zzdrv);
                this.zzdve = null;
            }
            return this.zzdrv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzyl() {
        zzaqu zzaqu2 = this;
        synchronized (zzaqu2) {
            this.zzdrv = null;
            this.zzdve = this.zzwv().zza(new zzaqw(this));
        }
        return this.zzyk();
    }

    final String zzym() {
        String string = this.zzbn(this.zzwv().getContext());
        if (string == null) {
            string = this.zzyn();
        }
        return string;
    }

    private final String zzyn() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zzs(this.zzwv().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzbn(Context context) {
        zzbq.zzgn((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzdx("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzdx("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzs(Context context, String string) {
        zzbq.zzgm((String)string);
        zzbq.zzgn((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzaqu zzaqu2) {
        return zzaqu2.zzyn();
    }
}

