/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzasl;

@Hide
public final class zzasq
extends zzari {
    private boolean zzebh;
    private boolean zzebi;
    private final AlarmManager zzebj = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzebk;

    protected zzasq(zzark zzark2) {
        super(zzark2);
    }

    @Override
    protected final void zzwk() {
        try {
            ActivityInfo activityInfo;
            this.cancel();
            if (zzasl.zzzy() > 0L && (activityInfo = this.getContext().getPackageManager().getReceiverInfo(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"), 2)) != null && activityInfo.enabled) {
                this.zzea("Receiver registered for local dispatch.");
                this.zzebh = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzaaj() {
        return this.zzebh;
    }

    public final boolean zzea() {
        return this.zzebi;
    }

    public final void schedule() {
        this.zzyk();
        zzbq.zza((boolean)this.zzebh, (Object)"Receiver not registered");
        long l = zzasl.zzzy();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzxx().elapsedRealtime() + l;
            this.zzebi = true;
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzea("Scheduling upload with JobScheduler");
                long l3 = l;
                zzasq zzasq2 = this;
                ComponentName componentName = new ComponentName(zzasq2.getContext(), "com.google.android.gms.analytics.AnalyticsJobService");
                JobScheduler jobScheduler = (JobScheduler)zzasq2.getContext().getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(zzasq2.getJobId(), componentName);
                builder.setMinimumLatency(l3);
                builder.setOverrideDeadline(l3 << 1);
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                builder.setExtras(persistableBundle);
                JobInfo jobInfo = builder.build();
                zzasq2.zza("Scheduling job. JobID", zzasq2.getJobId());
                jobScheduler.schedule(jobInfo);
                return;
            }
            this.zzea("Scheduling upload with AlarmManager");
            this.zzebj.setInexactRepeating(2, l2, l, this.zzaak());
        }
    }

    private final PendingIntent zzaak() {
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzebi = false;
        this.zzebj.cancel(this.zzaak());
        if (Build.VERSION.SDK_INT >= 24) {
            zzasq zzasq2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzasq2.getContext().getSystemService("jobscheduler");
            zzasq2.zza("Cancelling job. JobID", zzasq2.getJobId());
            jobScheduler.cancel(zzasq2.getJobId());
        }
    }

    private final int getJobId() {
        if (this.zzebk == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzebk = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzebk;
    }
}

