/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzc;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzcp;
import com.google.android.gms.internal.measurement.zzdg;

@VisibleForTesting
public class CampaignTrackingReceiver
extends BroadcastReceiver {
    private static Boolean zzre;

    public CampaignTrackingReceiver() {
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzre != null) {
            return zzre;
        }
        boolean bl = zzdg.zza(context, "com.google.android.gms.analytics.CampaignTrackingReceiver", true);
        zzre = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onReceive(Context context, Intent intent) {
        String string;
        zzaw zzaw2 = zzaw.zzc(context);
        zzcp zzcp2 = zzaw2.zzby();
        if (intent == null) {
            zzcp2.zzt("CampaignTrackingReceiver received null intent");
            return;
        }
        String string2 = intent.getStringExtra("referrer");
        String string3 = intent.getAction();
        zzcp2.zza("CampaignTrackingReceiver received", (Object)string3);
        if (!"com.android.vending.INSTALL_REFERRER".equals(string3) || TextUtils.isEmpty((CharSequence)string2)) {
            zzcp2.zzt("CampaignTrackingReceiver received unexpected intent without referrer extra");
            return;
        }
        this.zza(context, string2);
        int n = zzbx.zzdy();
        if (string2.length() <= n) {
            string = string2;
        } else {
            zzcp2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n);
            string = string2.substring(0, n);
        }
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        zzaw2.zzcc().zza(string, new zzc(this, pendingResult));
    }

    protected void zza(Context context, String string) {
    }
}

