/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.internal.measurement.zzz;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzat
implements zzo {
    private static DecimalFormat zzrb;
    private final zzaw zzqx;
    private final String zzrc;
    private final Uri zzrd;

    public zzb(zzaw zzaw2, String string) {
        this(zzaw2, string, true, false);
    }

    private zzb(zzaw zzaw2, String string, boolean bl, boolean bl2) {
        super(zzaw2);
        Preconditions.checkNotEmpty((String)string);
        this.zzqx = zzaw2;
        this.zzrc = string;
        this.zzrd = zzb.zzb(this.zzrc);
    }

    static Uri zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzo() {
        return this.zzrd;
    }

    @Override
    public final void zzb(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        Preconditions.checkArgument((boolean)zzg2.zzx(), (Object)"Can't deliver not submitted measurement");
        Preconditions.checkNotMainThread((String)"deliver should be called on worker thread");
        zzg zzg3 = zzg2.zzs();
        zzag zzag2 = zzg3.zzb(zzag.class);
        if (TextUtils.isEmpty((CharSequence)zzag2.zzbc())) {
            this.zzby().zza(zzb.zzc(zzg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzag2.zzbd())) {
            this.zzby().zza(zzb.zzc(zzg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzqx.zzco().getAppOptOut()) {
            return;
        }
        double d = zzag2.zzbj();
        if (zzdg.zza(d, zzag2.zzbd())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzg3);
        map.put("v", "1");
        map.put("_v", zzav.zzwa);
        map.put("tid", this.zzrc);
        if (this.zzqx.zzco().isDryRunEnabled()) {
            Map<String, String> map2 = map;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzdg.zzb(hashMap, "uid", zzag2.zzbe());
        zzx zzx2 = zzg2.zza(zzx.class);
        if (zzx2 != null) {
            zzdg.zzb(hashMap, "an", zzx2.zzaj());
            zzdg.zzb(hashMap, "aid", zzx2.zzal());
            zzdg.zzb(hashMap, "av", zzx2.zzak());
            zzdg.zzb(hashMap, "aiid", zzx2.zzam());
        }
        zzaz zzaz2 = new zzaz(0L, zzag2.zzbd(), this.zzrc, !TextUtils.isEmpty((CharSequence)zzag2.zzbf()), 0L, hashMap);
        long l = this.zzcc().zza(zzaz2);
        map.put("_s", String.valueOf(l));
        zzck zzck2 = new zzck(this.zzby(), map, zzg2.zzv(), true);
        this.zzcc().zza(zzck2);
    }

    @VisibleForTesting
    private static Map<String, String> zzc(zzg zzg2) {
        zzx zzx2;
        zzaa zzaa2;
        Object object;
        Object object2;
        Object object3;
        zzz zzz2;
        zzaj zzaj2;
        zzai zzai2;
        zzaf zzaf2;
        zzy zzy2;
        zzae zzae2;
        Object object4;
        Object object5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzab zzab2 = zzg2.zza(zzab.class);
        if (zzab2 != null) {
            object5 = zzab2.zzaw().entrySet().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (Map.Entry)object5.next();
                Object v = object4.getValue();
                if ((v == null ? null : (v instanceof String ? (!TextUtils.isEmpty((CharSequence)(object6 = (String)v)) ? object6 : null) : (v instanceof Double ? ((Double)(object6 = (Double)v) != 0.0 ? zzb.zza((Double)object6) : null) : (v instanceof Boolean ? (v != Boolean.FALSE ? "1" : null) : (zzae2 = String.valueOf(v)))))) == null) continue;
                hashMap.put((String)object4.getKey(), (String)((Object)zzae2));
            }
        }
        if ((object5 = zzg2.zza(zzag.class)) != null) {
            zzb.zza(hashMap, "t", ((zzag)object5).zzbc());
            zzb.zza(hashMap, "cid", ((zzag)object5).zzbd());
            zzb.zza(hashMap, "uid", ((zzag)object5).zzbe());
            zzb.zza(hashMap, "sc", ((zzag)object5).zzbh());
            zzb.zza(hashMap, "sf", ((zzag)object5).zzbj());
            zzb.zza(hashMap, "ni", ((zzag)object5).zzbi());
            zzb.zza(hashMap, "adid", ((zzag)object5).zzbf());
            zzb.zza(hashMap, "ate", ((zzag)object5).zzbg());
        }
        if ((object4 = zzg2.zza(zzah.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzah)object4).zzbk());
            zzb.zza(hashMap, "a", ((zzah)object4).zzbl());
            zzb.zza(hashMap, "dr", ((zzah)object4).zzbm());
        }
        if ((zzae2 = zzg2.zza(zzae.class)) != null) {
            zzb.zza(hashMap, "ec", zzae2.zzbb());
            zzb.zza(hashMap, "ea", zzae2.getAction());
            zzb.zza(hashMap, "el", zzae2.getLabel());
            zzb.zza(hashMap, "ev", zzae2.getValue());
        }
        if ((zzy2 = zzg2.zza(zzy.class)) != null) {
            zzb.zza(hashMap, "cn", zzy2.getName());
            zzb.zza(hashMap, "cs", zzy2.getSource());
            zzb.zza(hashMap, "cm", zzy2.zzan());
            zzb.zza(hashMap, "ck", zzy2.zzao());
            zzb.zza(hashMap, "cc", zzy2.zzap());
            zzb.zza(hashMap, "ci", zzy2.getId());
            zzb.zza(hashMap, "anid", zzy2.zzaq());
            zzb.zza(hashMap, "gclid", zzy2.zzar());
            zzb.zza(hashMap, "dclid", zzy2.zzas());
            zzb.zza(hashMap, "aclid", zzy2.zzat());
        }
        if ((zzaf2 = zzg2.zza(zzaf.class)) != null) {
            zzb.zza(hashMap, "exd", zzaf2.zzum);
            zzb.zza(hashMap, "exf", zzaf2.zzun);
        }
        if ((zzai2 = zzg2.zza(zzai.class)) != null) {
            zzb.zza(hashMap, "sn", zzai2.zzvd);
            zzb.zza(hashMap, "sa", zzai2.zzve);
            zzb.zza(hashMap, "st", zzai2.zzvf);
        }
        if ((zzaj2 = zzg2.zza(zzaj.class)) != null) {
            zzb.zza(hashMap, "utv", zzaj2.zzvg);
            zzb.zza(hashMap, "utt", zzaj2.zzvh);
            zzb.zza(hashMap, "utc", zzaj2.mCategory);
            zzb.zza(hashMap, "utl", zzaj2.zzvi);
        }
        if ((zzz2 = zzg2.zza(zzz.class)) != null) {
            object3 = zzz2.zzau().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = zzd.zze(object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((zzaa2 = zzg2.zza(zzaa.class)) != null) {
            object2 = zzaa2.zzav().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = zzd.zzg((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zza((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzg2.zza(zzad.class)) != null) {
            object2 = ((zzad)object3).zzax();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzad)object3).zzba()) {
                hashMap.putAll(promotion.zzn(zzd.zzk(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzad)object3).zzay()) {
                hashMap.putAll(product.zzn(zzd.zzi(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzad)object3).zzaz().entrySet()) {
                List<Product> list = entry.getValue();
                String string = zzd.zzn(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzl(n2));
                    hashMap.putAll(product.zzn(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzg2.zza(zzac.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzac)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzac)object2).zzug);
            zzb.zza(hashMap, "sr", ((zzac)object2).zzuh, ((zzac)object2).zzui);
            zzb.zza(hashMap, "vp", ((zzac)object2).zzuj, ((zzac)object2).zzuk);
        }
        if ((zzx2 = zzg2.zza(zzx.class)) != null) {
            zzb.zza(hashMap, "an", zzx2.zzaj());
            zzb.zza(hashMap, "aid", zzx2.zzal());
            zzb.zza(hashMap, "aiid", zzx2.zzam());
            zzb.zza(hashMap, "av", zzx2.zzak());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    private static String zza(double d) {
        if (zzrb == null) {
            zzrb = new DecimalFormat("0.######");
        }
        return zzrb.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zza(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }
}

