/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzcp;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzdh;

@SuppressLint(value={"StaticFieldLeak"})
public class zzaw {
    private static volatile zzaw zzwb;
    private final Context zzri;
    private final Context zzwc;
    private final Clock zzrz;
    private final zzbx zzwd;
    private final zzcp zzwe;
    private final zzk zzwf;
    private final zzal zzwg;
    private final zzcc zzwh;
    private final zzdh zzwi;
    private final zzct zzwj;
    private final GoogleAnalytics zzwk;
    private final zzbo zzwl;
    private final zzak zzwm;
    private final zzbh zzwn;
    private final zzcb zzwo;

    private zzaw(zzay zzay2) {
        Context context = zzay2.getApplicationContext();
        Preconditions.checkNotNull((Object)context, (Object)"Application context can't be null");
        Context context2 = zzay2.zzcm();
        Preconditions.checkNotNull((Object)context2);
        this.zzri = context;
        this.zzwc = context2;
        this.zzrz = DefaultClock.getInstance();
        Object object = this;
        this.zzwd = new zzbx((zzaw)object);
        object = this;
        zzcp zzcp2 = new zzcp((zzaw)object);
        zzcp2.zzq();
        this.zzwe = zzcp2;
        Object object2 = zzav.VERSION;
        this.zzby().zzs(new StringBuilder(134 + String.valueOf(object2).length()).append("Google Analytics ").append((String)object2).append(" is starting up. To enable debug logging on a device run:\n  adb shell setprop log.tag.GAv4 DEBUG\n  adb logcat -s GAv4").toString());
        object = this;
        object2 = new zzct((zzaw)object);
        ((zzau)object2).zzq();
        this.zzwj = object2;
        object = this;
        zzdh zzdh2 = new zzdh((zzaw)object);
        zzdh2.zzq();
        this.zzwi = zzdh2;
        zzaw zzaw2 = this;
        object = zzay2;
        zzal zzal2 = new zzal(zzaw2, (zzay)object);
        object = this;
        zzbo zzbo2 = new zzbo((zzaw)object);
        object = this;
        zzak zzak2 = new zzak((zzaw)object);
        object = this;
        zzbh zzbh2 = new zzbh((zzaw)object);
        object = this;
        zzcb zzcb2 = new zzcb((zzaw)object);
        zzk zzk2 = zzk.zzb(context);
        object = this;
        zzk2.zza(new zzax((zzaw)object));
        this.zzwf = zzk2;
        object = this;
        GoogleAnalytics googleAnalytics = new GoogleAnalytics((zzaw)object);
        zzbo2.zzq();
        this.zzwl = zzbo2;
        zzak2.zzq();
        this.zzwm = zzak2;
        zzbh2.zzq();
        this.zzwn = zzbh2;
        zzcb2.zzq();
        this.zzwo = zzcb2;
        object = this;
        zzcc zzcc2 = new zzcc((zzaw)object);
        zzcc2.zzq();
        this.zzwh = zzcc2;
        zzal2.zzq();
        this.zzwg = zzal2;
        googleAnalytics.zzq();
        this.zzwk = googleAnalytics;
        zzal2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzaw zzc(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzwb != null) return zzwb;
        Class<zzaw> clazz = zzaw.class;
        synchronized (zzaw.class) {
            zzaw zzaw2;
            if (zzwb != null) return zzwb;
            Clock clock = DefaultClock.getInstance();
            long l = clock.elapsedRealtime();
            zzay zzay2 = new zzay(context);
            zzwb = zzaw2 = new zzaw(zzay2);
            GoogleAnalytics.zzr();
            long l2 = clock.elapsedRealtime() - l;
            long l3 = zzcf.zzaal.get();
            if (l2 <= l3) return zzwb;
            zzaw2.zzby().zzc("Slow initialization (ms)", l2, l3);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzwb;
        }
    }

    public final Context getContext() {
        return this.zzri;
    }

    public final Context zzcm() {
        return this.zzwc;
    }

    public final Clock zzbx() {
        return this.zzrz;
    }

    public final zzbx zzbz() {
        return this.zzwd;
    }

    public final zzcp zzby() {
        zzaw.zza(this.zzwe);
        return this.zzwe;
    }

    public final zzcp zzcn() {
        return this.zzwe;
    }

    public final zzk zzca() {
        Preconditions.checkNotNull((Object)this.zzwf);
        return this.zzwf;
    }

    public final zzal zzcc() {
        zzaw.zza(this.zzwg);
        return this.zzwg;
    }

    public final zzcc zzcd() {
        zzaw.zza(this.zzwh);
        return this.zzwh;
    }

    public final GoogleAnalytics zzco() {
        Preconditions.checkNotNull((Object)this.zzwk);
        Preconditions.checkArgument((boolean)this.zzwk.isInitialized(), (Object)"Analytics instance not initialized");
        return this.zzwk;
    }

    public final zzdh zzce() {
        zzaw.zza(this.zzwi);
        return this.zzwi;
    }

    public final zzct zzcf() {
        zzaw.zza(this.zzwj);
        return this.zzwj;
    }

    public final zzct zzcp() {
        if (this.zzwj == null || !this.zzwj.isInitialized()) {
            return null;
        }
        return this.zzwj;
    }

    public final zzak zzcq() {
        zzaw.zza(this.zzwm);
        return this.zzwm;
    }

    public final zzbo zzcr() {
        zzaw.zza(this.zzwl);
        return this.zzwl;
    }

    public final zzbh zzci() {
        zzaw.zza(this.zzwn);
        return this.zzwn;
    }

    public final zzcb zzcj() {
        return this.zzwo;
    }

    private static void zza(zzau zzau2) {
        Preconditions.checkNotNull((Object)zzau2, (Object)"Analytics service not created/initialized");
        Preconditions.checkArgument((boolean)zzau2.isInitialized(), (Object)"Analytics service not initialized");
    }
}

