/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbu;
import com.google.android.gms.internal.measurement.zzbw;
import java.io.IOException;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

class zzbv<T extends zzbu>
extends zzat {
    private zzbw<T> zzyj;

    public zzbv(zzaw zzaw2, zzbw<T> zzbw2) {
        super(zzaw2);
        this.zzyj = zzbw2;
    }

    public final T zzq(int n) {
        try {
            return this.zza(this.zzbw().zzcm().getResources().getXml(n));
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzd("inflate() called with unknown resourceId", (Object)notFoundException);
            return null;
        }
    }

    private final T zza(XmlResourceParser xmlResourceParser) {
        try {
            xmlResourceParser.next();
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (xmlResourceParser.getEventType() == 2) {
                    String string;
                    String string2;
                    String string3 = xmlResourceParser.getName().toLowerCase(Locale.US);
                    if (string3.equals("screenname")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            this.zzyj.zzb(string2, string);
                        }
                    } else if (string3.equals("string")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && string != null) {
                            this.zzyj.zzc(string2, string);
                        }
                    } else if (string3.equals("bool")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                boolean bl = Boolean.parseBoolean(string);
                                this.zzyj.zza(string2, bl);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing bool configuration value", string, numberFormatException);
                            }
                        }
                    } else if (string3.equals("integer")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                int n2 = Integer.parseInt(string);
                                this.zzyj.zzb(string2, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing int configuration value", string, numberFormatException);
                            }
                        }
                    }
                }
                n = xmlResourceParser.next();
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            this.zze("Error parsing tracker configuration file", throwable);
        }
        return this.zzyj.zzdv();
    }
}

