/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbn;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcs;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

final class zzcr
extends zzau {
    private final String zzabl;
    private final zzdc zzabm;
    private static final byte[] zzabn = "\n".getBytes();

    zzcr(zzaw zzaw2) {
        super(zzaw2);
        String string = Build.ID;
        String string2 = Build.MODEL;
        String string3 = zzdg.zza(Locale.getDefault());
        String string4 = Build.VERSION.RELEASE;
        String string5 = zzav.VERSION;
        String string6 = "GoogleAnalytics";
        this.zzabl = String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string6, string5, string4, string3, string2, string);
        this.zzabm = new zzdc(zzaw2.zzbx());
    }

    @Override
    protected final void zzag() {
        this.zza("Network initialized. User agent", this.zzabl);
    }

    public final boolean zzfb() {
        zzk.zzaf();
        this.zzcl();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {}
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzq("No network connectivity");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final List<Long> zzb(List<zzck> var1_1) {
        block12: {
            zzk.zzaf();
            this.zzcl();
            Preconditions.checkNotNull(var1_1);
            if (!this.zzbz().zzeg().isEmpty() && this.zzabm.zzj((long)zzcf.zzzx.get().intValue() * 1000L)) break block12;
            var2_2 = false;
            ** GOTO lbl-1000
        }
        v0 = var2_2 = zzbn.zzz(zzcf.zzzq.get()) != zzbn.zzxw;
        if (zzbt.zzaa(zzcf.zzzr.get()) == zzbt.zzyh) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var3_3 = false;
        }
        if (var2_2) {
            var6_4 = var3_3;
            var5_6 = var1_1;
            var4_8 = this;
            Preconditions.checkArgument((boolean)(var5_6.isEmpty() == false));
            var4_8.zza("Uploading batched hits. compression, count", var6_4, var5_6.size());
            var7_10 = new zzcs(var4_8);
            var8_12 = new ArrayList<Long>();
            for (zzck var10_16 : var5_6) {
                if (!var7_10.zze(var10_16)) break;
                var8_12.add(var10_16.zzeq());
            }
            if (var7_10.zzfe() == 0) {
                return var8_12;
            }
            var9_14 = var4_8.zzfc();
            if (var9_14 == null) {
                var4_8.zzu("Failed to build batching endpoint url");
            } else {
                var10_17 = var6_4 != false ? var4_8.zzb(var9_14, var7_10.getPayload()) : var4_8.zza(var9_14, var7_10.getPayload());
                if (200 == var10_17) {
                    var4_8.zza("Batched upload completed. Hits batched", var7_10.zzfe());
                    return var8_12;
                }
                var4_8.zza("Network error uploading hits. status code", var10_17);
                if (var4_8.zzbz().zzeg().contains(var10_17)) {
                    var4_8.zzt("Server instructed the client to stop batching");
                    var4_8.zzabm.start();
                }
            }
            return Collections.emptyList();
        }
        var5_7 = var1_1;
        var4_9 = this;
        var6_5 = new ArrayList<Long>(var5_7.size());
        var7_11 = var5_7.iterator();
        while (var7_11.hasNext()) {
            block14: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                block16: {
                                    block13: {
                                        var10_18 = var8_13 = var7_11.next();
                                        var9_15 = var4_9;
                                        Preconditions.checkNotNull((Object)var10_18);
                                        var11_19 = var9_15.zza(var10_18, var10_18.zzet() == false);
                                        if (var11_19 != null) break block13;
                                        var9_15.zzby().zza(var10_18, "Error formatting hit for upload");
                                        v2 = true;
                                        break block14;
                                    }
                                    if (var11_19.length() > zzcf.zzzp.get()) break block15;
                                    var12_20 = var9_15.zzb(var10_18, var11_19);
                                    if (var12_20 != null) break block16;
                                    var9_15.zzu("Failed to build collect GET endpoint url");
                                    ** GOTO lbl-1000
                                }
                                v2 = var9_15.zza((URL)var12_20) == 200;
                                break block14;
                            }
                            var11_19 = var9_15.zza(var10_18, false);
                            if (var11_19 != null) break block17;
                            var9_15.zzby().zza(var10_18, "Error formatting hit for POST upload");
                            v2 = true;
                            break block14;
                        }
                        v3 = var11_19.getBytes();
                        var12_20 = v3;
                        if (v3.length <= zzcf.zzzu.get()) break block18;
                        var9_15.zzby().zza(var10_18, "Hit payload exceeds size limit");
                        v2 = true;
                        break block14;
                    }
                    var13_21 = var9_15.zzd(var10_18);
                    if (var13_21 != null) break block19;
                    var9_15.zzu("Failed to build collect POST endpoint url");
                    ** GOTO lbl-1000
                }
                if (var9_15.zza(var13_21, (byte[])var12_20) == 200) {
                    v2 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v2 = false;
                }
            }
            if (!v2) break;
            var6_5.add(var8_13.zzeq());
            if (var6_5.size() < zzbx.zzeb()) continue;
        }
        return var6_5;
    }

    private final int zza(URL uRL) {
        Preconditions.checkNotNull((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.connect();
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzcc().zzbv();
            }
            this.zzb("GET status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            return 0;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private final int zza(URL uRL, byte[] byArray) {
        Preconditions.checkNotNull((Object)uRL);
        Preconditions.checkNotNull((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (zzcr.zzck()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzcc().zzbv();
            }
            this.zzb("POST status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private final int zzb(URL uRL, byte[] byArray) {
        Preconditions.checkNotNull((Object)uRL);
        Preconditions.checkNotNull((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            byte[] byArray2 = byArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray2);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            this.zza("POST compressed size, ratio %, url", byArray3.length, 100L * (long)byArray3.length / (long)byArray.length, uRL);
            if (byArray3.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray3.length, byArray.length);
            }
            if (zzcr.zzck()) {
                String string = String.valueOf(new String(byArray));
                this.zza("Post payload", string.length() != 0 ? "\n".concat(string) : new String("\n"));
            }
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray3.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray3);
            outputStream.close();
            outputStream = null;
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzcc().zzbv();
            }
            this.zzb("POST status", n);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zza(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.zze("Error closing http connection input stream", iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.zze("Error closing http connection input stream", iOException);
            return;
        }
    }

    @VisibleForTesting
    private final HttpURLConnection zzb(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(zzcf.zzzz.get());
        httpURLConnection.setReadTimeout(zzcf.zzaaa.get());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzabl);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private final URL zzd(zzck zzck2) {
        String string;
        if (zzck2.zzet()) {
            String string2 = String.valueOf(zzbx.zzed());
            String string3 = String.valueOf(zzbx.zzef());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            String string4 = String.valueOf(zzbx.zzee());
            String string5 = String.valueOf(zzbx.zzef());
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private final URL zzb(zzck zzck2, String string) {
        String string2;
        String string3;
        if (zzck2.zzet()) {
            string3 = zzbx.zzed();
            String string4 = zzbx.zzef();
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append(string3).append(string4).append("?").append(string).toString();
        } else {
            string3 = zzbx.zzee();
            String string5 = zzbx.zzef();
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string5).length() + String.valueOf(string).length()).append(string3).append(string5).append("?").append(string).toString();
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private final URL zzfc() {
        String string = String.valueOf(zzbx.zzed());
        String string2 = String.valueOf(zzcf.zzzo.get());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    @VisibleForTesting
    final String zza(zzck zzck2, boolean bl) {
        Preconditions.checkNotNull((Object)zzck2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzck2.zzcw().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                zzcr.zza(stringBuilder, string, entry.getValue());
            }
            zzcr.zza(stringBuilder, "ht", String.valueOf(zzck2.zzer()));
            long l = this.zzbx().currentTimeMillis() - zzck2.zzer();
            zzcr.zza(stringBuilder, "qt", String.valueOf(l));
            if (bl) {
                long l2 = zzck2.zzeu();
                String string = l2 != 0L ? String.valueOf(l2) : String.valueOf(zzck2.zzeq());
                zzcr.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private static void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    static /* synthetic */ byte[] zzfd() {
        return zzabn;
    }
}

