/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzfc;
import java.util.ArrayList;

@VisibleForTesting
public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    @Nullable
    private final Thread.UncaughtExceptionHandler zza;
    private final Tracker zzb;
    private final Context zzc;
    @Nullable
    private ExceptionParser zzd;
    @Nullable
    private GoogleAnalytics zze;

    @Nullable
    public ExceptionParser getExceptionParser() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ExceptionReporter(@NonNull Tracker tracker, @Nullable Thread.UncaughtExceptionHandler originalHandler, @NonNull Context context) {
        void var2_2;
        void var3_3;
        Object this_;
        StandardExceptionParser standardExceptionParser;
        if (standardExceptionParser == null) {
            this_ = new NullPointerException("tracker cannot be null");
            throw this_;
        }
        if (var3_3 == null) {
            this_ = new NullPointerException("context cannot be null");
            throw this_;
        }
        ((ExceptionReporter)this_).zza = var2_2;
        ((ExceptionReporter)this_).zzb = standardExceptionParser;
        ArrayList<String> arrayList = new ArrayList<String>();
        standardExceptionParser = new StandardExceptionParser((Context)var3_3, arrayList);
        ((ExceptionReporter)this_).zzd = standardExceptionParser;
        ((ExceptionReporter)this_).zzc = var3_3.getApplicationContext();
        this_ = var2_2 == null ? "null" : var2_2.getClass().getName();
        zzfc.zzd("ExceptionReporter created, original handler is ".concat(String.valueOf(this_)));
    }

    /*
     * WARNING - void declaration
     */
    public void setExceptionParser(@Nullable ExceptionParser exceptionParser) {
        void var1_1;
        this.zzd = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
        void var2_2;
        Object object;
        void var1_1;
        if (this.zzd != null) {
            object = var1_1 != null ? var1_1.getName() : null;
            object = this.zzd.getDescription((String)object, (Throwable)var2_2);
        } else {
            object = "UncaughtException";
        }
        zzfc.zzd("Reporting uncaught exception: ".concat(String.valueOf(object)));
        Tracker tracker = this.zzb;
        HitBuilders.ExceptionBuilder exceptionBuilder = new HitBuilders.ExceptionBuilder();
        exceptionBuilder.setDescription((String)object);
        exceptionBuilder.setFatal(true);
        tracker.send(exceptionBuilder.build());
        if (this.zze == null) {
            this.zze = GoogleAnalytics.getInstance(this.zzc);
        }
        object = this.zze;
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((zza)object).zzb().zzf().zzn();
        if (this.zza != null) {
            zzfc.zzd("Passing exception to the original handler");
            this.zza.uncaughtException((Thread)var1_1, (Throwable)var2_2);
            return;
        }
    }

    @Nullable
    final Thread.UncaughtExceptionHandler zza() {
        return this.zza;
    }
}

