/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzbu;
import com.google.android.gms.internal.gtm.zzbx;
import com.google.android.gms.internal.gtm.zzfq;
import com.google.android.gms.internal.gtm.zzfu;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

@VisibleForTesting
public final class zzbk
extends zzbu {
    public static boolean zza;
    private AdvertisingIdClient.Info zzb;
    private final zzfq zzc;
    private String zzd;
    private boolean zze = false;
    private final Object zzf;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized AdvertisingIdClient.Info zzc() {
        AdvertisingIdClient.Info info;
        block28: {
            block34: {
                boolean bl;
                block31: {
                    block27: {
                        block25: {
                            if (!this.zzc.zzc(1000L)) return this.zzb;
                            this.zzc.zzb();
                            try {
                                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzo());
                            }
                            catch (IllegalStateException illegalStateException) {
                                this.zzQ("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
                                info = null;
                            }
                            catch (Exception exception) {
                                if (zza) break block25;
                                zza = true;
                                this.zzR("Error getting advertiser id", exception);
                                info = null;
                            }
                            break block27;
                        }
                        info = null;
                    }
                    Object object = this.zzb;
                    String string = info == null ? null : info.getId();
                    if (TextUtils.isEmpty((CharSequence)string)) break block28;
                    String string2 = this.zzv().zzb();
                    Object object2 = this.zzf;
                    synchronized (object2) {
                        String string3;
                        boolean bl2;
                        block35: {
                            block33: {
                                block29: {
                                    block26: {
                                        String string4;
                                        Object object3;
                                        block30: {
                                            boolean bl3 = this.zze;
                                            if (!bl3) {
                                                object = this.zzo().openFileInput("gaClientIdData");
                                                object3 = new byte[128];
                                                int n = ((FileInputStream)object).read((byte[])object3, 0, 128);
                                                int n2 = ((FileInputStream)object).available();
                                                if (n2 > 0) {
                                                    this.zzQ("Hash file seems corrupted, deleting it.");
                                                    ((FileInputStream)object).close();
                                                    this.zzo().deleteFile("gaClientIdData");
                                                    object = null;
                                                    break block26;
                                                }
                                                if (n <= 0) {
                                                    this.zzN("Hash file is empty.");
                                                    ((FileInputStream)object).close();
                                                    object = null;
                                                    break block26;
                                                }
                                                string4 = new String((byte[])object3, 0, n);
                                                ((FileInputStream)object).close();
                                                object = string4;
                                                break block26;
                                            }
                                            bl3 = TextUtils.isEmpty((CharSequence)this.zzd);
                                            if (!bl3) break block29;
                                            if ((object = object == null ? null : object.getId()) != null) break block30;
                                            object = new StringBuilder();
                                            ((StringBuilder)object).append(string);
                                            ((StringBuilder)object).append(string2);
                                            bl = this.zzf(((StringBuilder)object).toString());
                                            break block31;
                                        }
                                        StringBuilder stringBuilder = new StringBuilder();
                                        stringBuilder.append((String)object);
                                        stringBuilder.append(string2);
                                        this.zzd = zzbk.zze(stringBuilder.toString());
                                        break block29;
                                        catch (FileNotFoundException fileNotFoundException) {
                                            object = null;
                                        }
                                        catch (IOException iOException) {
                                            block32: {
                                                object3 = null;
                                                break block32;
                                                catch (FileNotFoundException fileNotFoundException) {
                                                    object = string4;
                                                    break block26;
                                                }
                                                catch (IOException iOException2) {
                                                    object3 = string4;
                                                }
                                            }
                                            this.zzR("Error reading Hash file, deleting it", object);
                                            this.zzo().deleteFile("gaClientIdData");
                                            object = object3;
                                        }
                                    }
                                    this.zzd = object;
                                    this.zze = true;
                                }
                                object = new StringBuilder();
                                ((StringBuilder)object).append(string);
                                ((StringBuilder)object).append(string2);
                                object = zzbk.zze(((StringBuilder)object).toString());
                                boolean bl4 = TextUtils.isEmpty((CharSequence)object);
                                if (!bl4) break block33;
                                break block34;
                            }
                            bl2 = ((String)object).equals(this.zzd);
                            if (!bl2) break block35;
                            break block28;
                        }
                        bl2 = TextUtils.isEmpty((CharSequence)this.zzd);
                        if (!bl2) {
                            this.zzN("Resetting the client id because Advertising Id changed.");
                            string3 = this.zzv().zze();
                            this.zzO("New client Id", string3);
                        } else {
                            string3 = string2;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string);
                        stringBuilder.append(string3);
                        bl = this.zzf(stringBuilder.toString());
                    }
                }
                if (bl) break block28;
            }
            this.zzI("Failed to reset client id on adid change. Not using adid");
            this.zzb = info = new AdvertisingIdClient.Info("", false);
            return this.zzb;
        }
        this.zzb = info;
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String zza() {
        ((zzbu)object).zzV();
        Object object = ((zzbk)object).zzc();
        object = object != null ? object.getId() : null;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        return object;
    }

    private static String zze(String string) {
        MessageDigest messageDigest = zzfu.zze("MD5");
        if (messageDigest == null) {
            return null;
        }
        Locale locale = Locale.US;
        Object[] objectArray = new Object[1];
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest(string.getBytes()));
        objectArray[0] = bigInteger;
        return String.format(locale, "%032X", objectArray);
    }

    zzbk(zzbx zzbx2) {
        super(zzbx2);
        Object object;
        this.zzf = object = new Object();
        this.zzc = object = new zzfq(zzbx2.zzr());
    }

    @Override
    protected final void zzd() {
    }

    public final boolean zzb() {
        zzbk2.zzV();
        zzbk zzbk2 = zzbk2.zzc();
        if (zzbk2 != null) {
            return !zzbk2.isLimitAdTrackingEnabled();
        }
        return false;
    }

    private final boolean zzf(String string) {
        try {
            string = zzbk.zze(string);
            this.zzN("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.zzo().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
            this.zzd = string;
            return true;
        }
        catch (IOException iOException) {
            this.zzJ("Error creating hash file", iOException);
            return false;
        }
    }
}

