/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import com.google.android.gms.analytics.zzr;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzbl;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbt;
import com.google.android.gms.internal.gtm.zzbx;

final class zzfe
extends BroadcastReceiver {
    @VisibleForTesting
    static final String zza = zzfe.class.getName();
    private final zzbx zzb;
    private boolean zzc;
    private boolean zzd;

    zzfe(zzbx zzbx2) {
        Preconditions.checkNotNull((Object)zzbx2);
        this.zzb = zzbx2;
    }

    public final void onReceive(Context object, Intent object2) {
        Object object3;
        ((zzfe)((Object)object3)).zzb.zzm();
        ((zzfe)((Object)object3)).zzb.zzf();
        object = object2.getAction();
        ((zzfe)((Object)object3)).zzb.zzm().zzO("NetworkBroadcastReceiver received action", object);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(object)) {
            boolean bl = ((zzfe)((Object)object3)).zze();
            if (((zzfe)((Object)object3)).zzd != bl) {
                ((zzfe)((Object)object3)).zzd = bl;
                object3 = ((zzfe)((Object)object3)).zzb.zzf();
                ((zzbt)object3).zzO("Network connectivity status changed", bl);
                object2 = ((zzbt)object3).zzq();
                zzbl zzbl2 = new zzbl((zzbs)object3, bl);
                ((zzr)object2).zzi(zzbl2);
                return;
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(object)) {
            if (!object2.hasExtra(zza)) {
                object3 = ((zzfe)((Object)object3)).zzb.zzf();
                ((zzbt)object3).zzN("Radio powered up");
                ((zzbs)object3).zzc();
                return;
            }
            return;
        }
        ((zzfe)((Object)object3)).zzb.zzm().zzR("NetworkBroadcastReceiver received unknown action", object);
    }

    public final void zza() {
        this.zzb.zzm();
        this.zzb.zzf();
        if (this.zzc) {
            return;
        }
        Context context = this.zzb.zza();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        intentFilter = new IntentFilter("com.google.analytics.RADIO_POWERED");
        intentFilter.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        this.zzd = this.zze();
        this.zzb.zzm().zzO("Registering connectivity change receiver. Network connected", this.zzd);
        this.zzc = true;
    }

    @VisibleForTesting
    public final void zzb() {
        zzfe zzfe2 = zzfe2.zzb.zza();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(zzfe2.getPackageName());
        intent.putExtra(zza, true);
        zzfe2.sendOrderedBroadcast(intent, null);
    }

    public final void zzc() {
        if (!this.zzc) {
            return;
        }
        this.zzb.zzm().zzN("Unregistering connectivity change receiver");
        this.zzc = false;
        this.zzd = false;
        Context context = this.zzb.zza();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzb.zzm().zzJ("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final boolean zzd() {
        if (!this.zzc) {
            this.zzb.zzm().zzQ("Connectivity unknown. Receiver not registered");
        }
        return this.zzd;
    }

    @VisibleForTesting
    protected final boolean zze() {
        block3: {
            zzfe zzfe2 = (ConnectivityManager)zzfe2.zzb.zza().getSystemService("connectivity");
            try {
                zzfe2 = zzfe2.getActiveNetworkInfo();
                if (zzfe2 == null) break block3;
            }
            catch (SecurityException securityException) {
                return false;
            }
            boolean bl = zzfe2.isConnected();
            if (!bl) break block3;
            return true;
        }
        return false;
    }
}

