/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.gtm.zzbl;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbx;

final class zzfe
extends BroadcastReceiver {
    @VisibleForTesting
    static final String zza = zzfe.class.getName();
    private final zzbx zzb;
    private boolean zzc;
    private boolean zzd;

    zzfe(zzbx zzbx2) {
        Preconditions.checkNotNull((Object)zzbx2);
        this.zzb = zzbx2;
    }

    public final void onReceive(Context object, Intent intent) {
        ((zzfe)((Object)zzbs2)).zzb.zzm();
        ((zzfe)((Object)zzbs2)).zzb.zzf();
        object = intent.getAction();
        ((zzfe)((Object)zzbs2)).zzb.zzm().zzO("NetworkBroadcastReceiver received action", object);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(object)) {
            boolean bl = ((zzfe)((Object)zzbs2)).zze();
            if (((zzfe)((Object)zzbs2)).zzd != bl) {
                ((zzfe)((Object)zzbs2)).zzd = bl;
                zzbs zzbs2 = ((zzfe)((Object)zzbs2)).zzb.zzf();
                zzbs2.zzO("Network connectivity status changed", bl);
                zzbs2.zzq().zzi(new zzbl(zzbs2, bl));
                return;
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(object)) {
            if (!intent.hasExtra(zza)) {
                zzbs zzbs3 = ((zzfe)((Object)zzbs2)).zzb.zzf();
                zzbs3.zzN("Radio powered up");
                zzbs3.zzc();
                return;
            }
            return;
        }
        ((zzfe)((Object)zzbs2)).zzb.zzm().zzR("NetworkBroadcastReceiver received unknown action", object);
    }

    public final void zza() {
        this.zzb.zzm();
        this.zzb.zzf();
        if (this.zzc) {
            return;
        }
        Context context = this.zzb.zza();
        zzfe zzfe2 = this;
        context.registerReceiver((BroadcastReceiver)zzfe2, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        IntentFilter intentFilter = new IntentFilter("com.google.analytics.RADIO_POWERED");
        intentFilter.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)zzfe2, intentFilter);
        this.zzd = this.zze();
        Boolean bl = this.zzd;
        this.zzb.zzm().zzO("Registering connectivity change receiver. Network connected", bl);
        this.zzc = true;
    }

    @VisibleForTesting
    public final void zzb() {
        Context context = this.zzb.zza();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zza, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final void zzc() {
        if (!this.zzc) {
            return;
        }
        this.zzb.zzm().zzN("Unregistering connectivity change receiver");
        this.zzc = false;
        this.zzd = false;
        Context context = this.zzb.zza();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzb.zzm().zzJ("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final boolean zzd() {
        if (!this.zzc) {
            this.zzb.zzm().zzQ("Connectivity unknown. Receiver not registered");
        }
        return this.zzd;
    }

    @VisibleForTesting
    protected final boolean zze() {
        block3: {
            zzfe zzfe2 = (ConnectivityManager)zzfe2.zzb.zza().getSystemService("connectivity");
            try {
                zzfe2 = zzfe2.getActiveNetworkInfo();
                if (zzfe2 == null) break block3;
            }
            catch (SecurityException securityException) {
                return false;
            }
            boolean bl = zzfe2.isConnected();
            if (!bl) break block3;
            return true;
        }
        return false;
    }
}

