/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zztx;

public class CampaignTrackingReceiver
extends BroadcastReceiver {
    static Object zzrs = new Object();
    static zztx zzTN;
    static Boolean zzTO;

    public static boolean zzU(Context context) {
        zzaa.zzz((Object)context);
        if (zzTO != null) {
            return zzTO;
        }
        boolean bl = zzao.zzb(context, "com.google.android.gms.analytics.CampaignTrackingReceiver", true);
        zzTO = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onReceive(Context context, Intent intent) {
        zzf zzf2 = zzf.zzX(context);
        zzaf zzaf2 = zzf2.zzlR();
        if (intent == null) {
            zzaf2.zzbJ("CampaignTrackingReceiver received null intent");
            return;
        }
        String string = intent.getStringExtra("referrer");
        String string2 = intent.getAction();
        zzaf2.zza("CampaignTrackingReceiver received", (Object)string2);
        if (!"com.android.vending.INSTALL_REFERRER".equals(string2) || TextUtils.isEmpty((CharSequence)string)) {
            zzaf2.zzbJ("CampaignTrackingReceiver received unexpected intent without referrer extra");
            return;
        }
        boolean bl = CampaignTrackingService.zzV(context);
        if (!bl) {
            zzaf2.zzbJ("CampaignTrackingService not registered or disabled. Installation tracking not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzh(context, string);
        if (zzf2.zzlS().zzmW()) {
            zzaf2.zzbK("Received unexpected installation campaign on package side");
            return;
        }
        Class<? extends CampaignTrackingService> clazz = this.zzko();
        zzaa.zzz(clazz);
        Intent intent2 = new Intent(context, clazz);
        intent2.putExtra("referrer", string);
        Object object = zzrs;
        synchronized (object) {
            context.startService(intent2);
            if (!bl) {
                return;
            }
            try {
                if (zzTN == null) {
                    zzTN = new zztx(context, 1, "Analytics campaign WakeLock");
                    zzTN.setReferenceCounted(false);
                }
                zzTN.acquire(1000L);
            }
            catch (SecurityException securityException) {
                zzaf2.zzbJ("CampaignTrackingService service at risk of not starting. For more reliable installation campaign reports, add the WAKE_LOCK permission to your manifest. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    protected Class<? extends CampaignTrackingService> zzko() {
        return CampaignTrackingService.class;
    }

    protected void zzh(Context context, String string) {
    }
}

