/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zza
extends zzd {
    public static boolean zzVS;
    private AdvertisingIdClient.Info zzVT;
    private final zzal zzVU;
    private String zzVV;
    private boolean zzVW = false;
    private Object zzVX = new Object();

    zza(zzf zzf2) {
        super(zzf2);
        this.zzVU = new zzal(zzf2.zzlQ());
    }

    @Override
    protected void zzkO() {
    }

    public boolean zzlt() {
        this.zzma();
        AdvertisingIdClient.Info info = this.zzlF();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zzlE() {
        this.zzma();
        AdvertisingIdClient.Info info = this.zzlF();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zzlF() {
        if (this.zzVU.zzx(1000L)) {
            this.zzVU.start();
            AdvertisingIdClient.Info info = this.zzlG();
            if (this.zza(this.zzVT, info)) {
                this.zzVT = info;
            } else {
                this.zzbK("Failed to reset client id on adid change. Not using adid");
                this.zzVT = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzVT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zzlW().zzmP();
        Object object = this.zzVX;
        synchronized (object) {
            String string4;
            if (!this.zzVW) {
                this.zzVV = this.zzlH();
                this.zzVW = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzVV)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    String string6 = String.valueOf(string);
                    String string7 = String.valueOf(string3);
                    return this.zzbF(string7.length() != 0 ? string6.concat(string7) : new String(string6));
                }
                String string8 = String.valueOf(string4);
                String string9 = String.valueOf(string3);
                this.zzVV = zza.zzbE(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string3);
            string4 = zza.zzbE(string11.length() != 0 ? string10.concat(string11) : new String(string10));
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzVV)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzVV)) {
                this.zzbG("Resetting the client id because Advertising Id changed.");
                string3 = this.zzlW().zzmQ();
                this.zza("New client Id", string3);
            }
            String string12 = String.valueOf(string);
            String string13 = String.valueOf(string3);
            return this.zzbF(string13.length() != 0 ? string12.concat(string13) : new String(string12));
        }
    }

    protected AdvertisingIdClient.Info zzlG() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbJ("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzVS) break block3;
                zzVS = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzbE(String string) {
        MessageDigest messageDigest = zzao.zzbZ("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzbF(String string) {
        try {
            String string2 = zza.zzbE(string);
            this.zzbG("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzVV = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzlH() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbJ("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzbG("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

