/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzaa;

class zzag
extends BroadcastReceiver {
    static final String zzYP = zzag.class.getName();
    private final zzf zzWg;
    private boolean zzYQ;
    private boolean zzYR;

    zzag(zzf zzf2) {
        zzaa.zzz((Object)zzf2);
        this.zzWg = zzf2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzob();
        String string = intent.getAction();
        this.zzWg.zzlR().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzod();
            if (this.zzYR != bl) {
                this.zzYR = bl;
                this.zzkw().zzR(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzYP)) {
                this.zzkw().zzlM();
            }
            return;
        }
        this.zzWg.zzlR().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzoa() {
        this.zzob();
        if (this.zzYQ) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzYR = this.zzod();
        this.zzWg.zzlR().zza("Registering connectivity change receiver. Network connected", this.zzYR);
        this.zzYQ = true;
    }

    private void zzob() {
        this.zzlR();
        this.zzkw();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzWg.zzlR().zzbG("Unregistering connectivity change receiver");
        this.zzYQ = false;
        this.zzYR = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzlR().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzoc() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzYP, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzYQ;
    }

    public boolean isConnected() {
        if (!this.zzYQ) {
            this.zzWg.zzlR().zzbJ("Connectivity unknown. Receiver not registered");
        }
        return this.zzYR;
    }

    protected boolean zzod() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzWg.getContext();
    }

    private zzaf zzlR() {
        return this.zzWg.zzlR();
    }

    private zzb zzkw() {
        return this.zzWg.zzkw();
    }
}

