/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zztx;

public final class zzak {
    private final Handler mHandler;
    private final zza zzZd;
    private final Context mContext;
    private static Boolean zzTP;

    public zzak(zza zza2) {
        this.mContext = zza2.getContext();
        zzaa.zzz((Object)this.mContext);
        this.zzZd = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzV(Context context) {
        zzaa.zzz((Object)context);
        if (zzTP != null) {
            return zzTP;
        }
        boolean bl = zzao.zzj(context, "com.google.android.gms.analytics.AnalyticsService");
        zzTP = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        zzf zzf2 = zzf.zzX(this.mContext);
        zzaf zzaf2 = zzf2.zzlR();
        if (zzf2.zzlS().zzmW()) {
            zzaf2.zzbG("Device AnalyticsService is starting up");
        } else {
            zzaf2.zzbG("Local AnalyticsService is starting up");
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzf zzf2 = zzf.zzX(this.mContext);
        zzaf zzaf2 = zzf2.zzlR();
        if (zzf2.zzlS().zzmW()) {
            zzaf2.zzbG("Device AnalyticsService is shutting down");
        } else {
            zzaf2.zzbG("Local AnalyticsService is shutting down");
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int n, final int n2) {
        this.zzkp();
        final zzf zzf2 = zzf.zzX(this.mContext);
        final zzaf zzaf2 = zzf2.zzlR();
        if (intent == null) {
            zzaf2.zzbJ("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        if (zzf2.zzlS().zzmW()) {
            zzaf2.zza("Device AnalyticsService called. startId, action", n2, string);
        } else {
            zzaf2.zza("Local AnalyticsService called. startId, action", n2, string);
        }
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            zzf2.zzkw().zza(new zzw(){

                @Override
                public void zzd(Throwable throwable) {
                    zzak.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzak.this.zzZd.callServiceStopSelfResult(n2);
                            if (bl) {
                                if (zzf2.zzlS().zzmW()) {
                                    zzaf2.zzbG("Device AnalyticsService processed last dispatch request");
                                } else {
                                    zzaf2.zzbG("Local AnalyticsService processed last dispatch request");
                                }
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkp() {
        try {
            Object object = zzaj.zzrs;
            synchronized (object) {
                zztx zztx2 = zzaj.zzTN;
                if (zztx2 != null && zztx2.isHeld()) {
                    zztx2.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

