/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza zzWD;
    private zzac zzWE;
    private final zzt zzWF;
    private zzal zzWG;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.zzWG = new zzal(zzf2.zzlQ());
        this.zzWD = new zza();
        this.zzWF = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zzmo();
            }
        };
    }

    @Override
    protected void zzkO() {
    }

    public boolean isConnected() {
        this.zzkN();
        this.zzma();
        return this.zzWE != null;
    }

    public boolean zzb(zzab zzab2) {
        zzaa.zzz((Object)zzab2);
        this.zzkN();
        this.zzma();
        zzac zzac2 = this.zzWE;
        if (zzac2 == null) {
            return false;
        }
        String string = zzab2.zznV() ? this.zzlS().zznk() : this.zzlS().zznl();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzm(), zzab2.zznT(), string, list);
            this.zzmn();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbG("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzmm() {
        this.zzkN();
        this.zzma();
        zzac zzac2 = this.zzWE;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zzlI();
            this.zzmn();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbG("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzmn() {
        this.zzWG.start();
        this.zzWF.zzv(this.zzlS().zznr());
    }

    public boolean connect() {
        this.zzkN();
        this.zzma();
        if (this.zzWE != null) {
            return true;
        }
        zzac zzac2 = this.zzWD.zzmp();
        if (zzac2 != null) {
            this.zzWE = zzac2;
            this.zzmn();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zzkN();
        this.zzWE = zzac2;
        this.zzmn();
        this.zzkw().onServiceConnected();
    }

    public void disconnect() {
        this.zzkN();
        this.zzma();
        try {
            zzb zzb2 = zzb.zzuH();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzWD);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzWE != null) {
            this.zzWE = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName componentName) {
        this.zzkN();
        if (this.zzWE != null) {
            this.zzWE = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.onDisconnect();
        }
    }

    private void zzmo() {
        this.zzkN();
        if (!this.isConnected()) {
            return;
        }
        this.zzbG("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzkw().zzlL();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac zzWI;
        private volatile boolean zzWJ;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zzmp() {
            zzi.this.zzkN();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzuH();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzWI = null;
                this.zzWJ = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzi.this.zzWD, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzWJ = false;
                    return null;
                }
                try {
                    long l = zzi.this.zzlS().zzns();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzbJ("Wait for service connect was interrupted");
                }
                this.zzWJ = false;
                zzac zzac2 = this.zzWI;
                this.zzWI = null;
                if (zzac2 == null) {
                    zzi.this.zzbK("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzaa.zzdc((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (iBinder == null) {
                        zzi.this.zzbK("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = iBinder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzak(iBinder);
                            zzi.this.zzbG("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzbK("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzuH().zza(zzi.this.getContext(), (ServiceConnection)zzi.this.zzWD);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzWJ) {
                        zzi.this.zzbJ("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zzlT().zzf(new Runnable((zzac)object){
                            final /* synthetic */ zzac zzWK;
                            {
                                this.zzWK = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzbH("Connected to service after a timeout");
                                    zzi.this.zza(this.zzWK);
                                }
                            }
                        });
                    } else {
                        this.zzWI = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName componentName) {
            zzaa.zzdc((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zzlT().zzf(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(componentName);
                }
            });
        }
    }
}

