/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzlw;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj zzWT;
    private final zzah zzWU;
    private final zzag zzWV;
    private final zzi zzWW;
    private long zzWX;
    private final zzt zzWY;
    private final zzt zzWZ;
    private final zzal zzXa;
    private long zzXb;
    private boolean zzXc;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzaa.zzz((Object)zzg2);
        this.zzWX = Long.MIN_VALUE;
        this.zzWV = zzg2.zzk(zzf2);
        this.zzWT = zzg2.zzm(zzf2);
        this.zzWU = zzg2.zzn(zzf2);
        this.zzWW = zzg2.zzo(zzf2);
        this.zzXa = new zzal(this.zzlQ());
        this.zzWY = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzmA();
            }
        };
        this.zzWZ = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzmB();
            }
        };
    }

    @Override
    protected void zzkO() {
        this.zzWT.initialize();
        this.zzWU.initialize();
        this.zzWW.initialize();
    }

    void start() {
        this.zzma();
        zzaa.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzlT().zzf(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzmz();
            }
        });
    }

    private void zzmy() {
        boolean bl;
        this.zzkN();
        zzf zzf2 = this.zzlO();
        Context context = zzf2.getContext();
        boolean bl2 = zzaj.zzU(context);
        if (!bl2) {
            this.zzbJ("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = zzak.zzV(context);
            if (!bl) {
                this.zzbK("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzU(context);
        if (!bl) {
            this.zzbJ("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzV(context);
            if (!bl3) {
                this.zzbJ("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbN(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zzmz() {
        this.zzma();
        if (!this.zzlS().zzmW()) {
            this.zzmy();
        }
        this.zzlV().zzoh();
        if (!this.zzbN("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbK("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzmO();
        }
        if (!this.zzbN("android.permission.INTERNET")) {
            this.zzbK("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzmO();
        }
        if (zzak.zzV(this.getContext())) {
            this.zzbG("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zzlS().zzmW()) {
            this.zzbK("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzbJ("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzXc || this.zzlS().zzmW() || this.zzWT.isEmpty())) {
            this.zzmC();
        }
        this.zzmG();
    }

    private void zzmA() {
        this.zzb(new zzw(){

            @Override
            public void zzd(Throwable throwable) {
                zzl.this.zzmG();
            }
        });
    }

    void zzlN() {
        this.zzkN();
        this.zzXb = this.zzlQ().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzkN();
        if (!this.zzlS().zzmW()) {
            this.zzmD();
        }
    }

    public void zzlL() {
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        this.zzbG("Service disconnected");
    }

    public void zzR(boolean bl) {
        this.zzmG();
    }

    private void zzmB() {
        try {
            this.zzWT.zzms();
            this.zzmG();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzWZ.zzv(this.zzlS().zzny());
    }

    protected void zzc(zzh zzh2) {
        this.zzkN();
        this.zzb("Sending first hit to property", zzh2.zzmj());
        if (this.zzlV().zzoi().zzx(this.zzlS().zznB())) {
            return;
        }
        String string = this.zzlV().zzol();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzlo zzlo2 = zzao.zza(this.zzlR(), string);
        this.zzb("Found relevant installation campaign", zzlo2);
        this.zza(zzh2, zzlo2);
    }

    public void zzu(long l) {
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        if (l < 0L) {
            l = 0L;
        }
        this.zzWX = l;
        this.zzmG();
    }

    protected void zzmC() {
        if (this.zzXc) {
            return;
        }
        if (!this.zzlS().zzmY()) {
            return;
        }
        if (this.zzWW.isConnected()) {
            return;
        }
        long l = this.zzlS().zznt();
        if (this.zzXa.zzx(l)) {
            this.zzXa.start();
            this.zzbG("Connecting to service");
            if (this.zzWW.connect()) {
                this.zzbG("Connected to service");
                this.zzXa.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzaa.zzz((Object)zzh2);
        this.zzma();
        this.zzkN();
        long l = -1L;
        try {
            this.zzWT.beginTransaction();
            this.zzWT.zza(zzh2.zzmi(), zzh2.zzku());
            l = this.zzWT.zza(zzh2.zzmi(), zzh2.zzku(), zzh2.zzmj());
            if (!bl) {
                zzh2.zzp(l);
            } else {
                zzh2.zzp(l + 1L);
            }
            this.zzWT.zzb(zzh2);
            this.zzWT.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return -1L;
        }
        finally {
            try {
                this.zzWT.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzab zzab2) {
        zzaa.zzz((Object)zzab2);
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        if (this.zzXc) {
            this.zzbH("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zzmC();
        if (this.zzWW.zzb(zzab2)) {
            this.zzbH("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zzlS().zzmW()) {
            this.zzlR().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzWT.zzc(zzab2);
            this.zzmG();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzlR().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zzlI() {
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        if (!this.zzlS().zzmW()) {
            this.zzbG("Delete all hits from local store");
            try {
                this.zzWT.zzmq();
                this.zzWT.zzmr();
                this.zzmG();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zzmC();
        if (this.zzWW.zzmm()) {
            this.zzbG("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zznX())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zzlV().zzom();
        Pair<String, Long> pair = zza2.zzop();
        if (pair == null) {
            return zzab2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        Object object = String.valueOf(l);
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
        object = new HashMap<String, String>(zzab2.zzm());
        object.put("_m", string2);
        return zzab.zza(this, zzab2, (Map<String, String>)object);
    }

    public void zzmD() {
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        this.zzlP();
        if (!this.zzlS().zzmY()) {
            this.zzbJ("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzWW.isConnected()) {
            this.zzbG("Service not connected");
            return;
        }
        if (this.zzWT.isEmpty()) {
            return;
        }
        this.zzbG("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.zzWT.zzr(this.zzlS().zznh());
                if (list.isEmpty()) {
                    this.zzmG();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzmK();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.zzWW.zzb(zzab2)) {
                    this.zzmG();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.zzWT.zzs(zzab2.zznS());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzmK();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzmE() {
        boolean bl;
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        this.zzbG("Dispatching a batch of local hits");
        boolean bl2 = !this.zzWW.isConnected() && !this.zzlS().zzmW();
        boolean bl3 = bl = !this.zzWU.zzod();
        if (bl2 && bl) {
            this.zzbG("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzlS().zznh(), this.zzlS().zzni());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.zzWT.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzWT.zzr(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbG("Store is empty, nothing to dispatch");
                        this.zzmK();
                        boolean bl4 = false;
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzmK();
                        boolean bl5 = false;
                        try {
                            this.zzWT.setTransactionSuccessful();
                            this.zzWT.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzmK();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zznS() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzmK();
                    boolean bl6 = false;
                    return false;
                }
                if (this.zzWW.isConnected() && !this.zzlS().zzmW()) {
                    this.zzbG("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzWW.zzb((zzab)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzab)object2).zznS());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzWT.zzs(((zzab)object2).zznS());
                            arrayList.add(((zzab)object2).zznS());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzmK();
                            boolean bl7 = false;
                            try {
                                this.zzWT.setTransactionSuccessful();
                                this.zzWT.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzmK();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzWU.zzod()) {
                    object2 = this.zzWU.zzs(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzWT.zzq((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzmK();
                        boolean bl8 = false;
                        try {
                            this.zzWT.setTransactionSuccessful();
                            this.zzWT.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzmK();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return false;
            }
            finally {
                try {
                    this.zzWT.setTransactionSuccessful();
                    this.zzWT.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzmK();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.zzXb);
    }

    public void zza(final zzw zzw2, final long l) {
        block8: {
            com.google.android.gms.analytics.zzi.zzkN();
            this.zzma();
            long l2 = -1L;
            long l3 = this.zzlV().zzoj();
            if (l3 != 0L) {
                l2 = Math.abs(this.zzlQ().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zzlS().zzmW()) {
                this.zzmC();
            }
            try {
                boolean bl = this.zzmE();
                if (bl) {
                    this.zzlT().zzf(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l);
                        }
                    });
                } else {
                    this.zzlV().zzok();
                    this.zzmG();
                    if (zzw2 != null) {
                        zzw2.zzd(null);
                    }
                    if (this.zzXb != l) {
                        this.zzWV.zzoc();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zzlV().zzok();
                this.zzmG();
                if (zzw2 == null) break block8;
                zzw2.zzd(throwable);
            }
        }
    }

    public void zzmF() {
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        this.zzbH("Sync dispatching local hits");
        long l = this.zzXb;
        if (!this.zzlS().zzmW()) {
            this.zzmC();
        }
        try {
            while (this.zzmE()) {
            }
            this.zzlV().zzok();
            this.zzmG();
            if (this.zzXb != l) {
                this.zzWV.zzoc();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzmG();
        }
    }

    public long zzmt() {
        com.google.android.gms.analytics.zzi.zzkN();
        this.zzma();
        try {
            return this.zzWT.zzmt();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzmG() {
        boolean bl;
        this.zzlO().zzkN();
        this.zzma();
        if (!this.zzmH()) {
            this.zzWV.unregister();
            this.zzmK();
            return;
        }
        if (this.zzWT.isEmpty()) {
            this.zzWV.unregister();
            this.zzmK();
            return;
        }
        if (!zzy.zzYm.get().booleanValue()) {
            this.zzWV.zzoa();
            bl = this.zzWV.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzmJ();
        } else {
            this.zzmK();
            this.zzmI();
        }
    }

    private boolean zzmH() {
        if (this.zzXc) {
            return false;
        }
        if (this.zzlS().zzmW() && !this.zzlS().zzmX()) {
            return false;
        }
        return this.zzmN() > 0L;
    }

    private void zzmI() {
        long l;
        long l2;
        long l3;
        zzv zzv2 = this.zzlU();
        if (!zzv2.zznG()) {
            return;
        }
        if (!zzv2.zzbW() && (l3 = this.zzmt()) != 0L && (l2 = Math.abs((l = this.zzlQ().currentTimeMillis()) - l3)) <= this.zzlS().zzng()) {
            long l4 = this.zzlS().zznf();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzv2.schedule();
        }
    }

    private void zzmJ() {
        long l;
        long l2;
        this.zzmI();
        long l3 = this.zzmN();
        long l4 = this.zzlV().zzoj();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zzlQ().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzlS().zznd(), l3)) : Math.min(this.zzlS().zznd(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzWY.zzbW()) {
            l = Math.max(1L, l5 + this.zzWY.zznD());
            this.zzWY.zzw(l);
        } else {
            this.zzWY.zzv(l5);
        }
    }

    private void zzmK() {
        this.zzmL();
        this.zzmM();
    }

    private void zzmL() {
        if (this.zzWY.zzbW()) {
            this.zzbG("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzWY.cancel();
    }

    private void zzmM() {
        zzv zzv2 = this.zzlU();
        if (zzv2.zzbW()) {
            zzv2.cancel();
        }
    }

    public long zzmN() {
        if (this.zzWX != Long.MIN_VALUE) {
            return this.zzWX;
        }
        long l = this.zzlS().zzne();
        if (this.zzkx().zznN()) {
            l = (long)this.zzkx().zzoE() * 1000L;
        }
        return l;
    }

    public void zzbO(String string) {
        zzaa.zzdl((String)string);
        this.zzkN();
        this.zzlP();
        zzlo zzlo2 = zzao.zza(this.zzlR(), string);
        if (zzlo2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzlV().zzol();
        if (string.equals(string2)) {
            this.zzbJ("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzlV().zzbT(string);
        if (this.zzlV().zzoi().zzx(this.zzlS().zznB())) {
            this.zzd("Campaign received too late, ignoring", zzlo2);
            return;
        }
        this.zzb("Received installation campaign", zzlo2);
        List<zzh> list = this.zzWT.zzt(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzlo2);
        }
    }

    private void zza(zzh zzh2, zzlo zzlo2) {
        zzaa.zzz((Object)zzh2);
        zzaa.zzz((Object)zzlo2);
        zza zza2 = new zza(this.zzlO());
        zza2.zzbf(zzh2.zzmj());
        zza2.enableAdvertisingIdCollection(zzh2.zzmk());
        zze zze2 = zza2.zzkk();
        zzlw zzlw2 = zze2.zzb(zzlw.class);
        zzlw2.zzbv("data");
        zzlw2.zzO(true);
        zze2.zza(zzlo2);
        zzlr zzlr2 = zze2.zzb(zzlr.class);
        zzln zzln2 = zze2.zzb(zzln.class);
        for (Map.Entry<String, String> entry : zzh2.zzm().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzln2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzln2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzln2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzln2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzlw2.setUserId(string2);
                continue;
            }
            zzlr2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzh2.zzmj(), zzlo2);
        zze2.zzn(this.zzlV().zzoh());
        zze2.zzkC();
    }

    public void zzmO() {
        this.zzma();
        this.zzkN();
        this.zzXc = true;
        this.zzWW.disconnect();
        this.zzmG();
    }
}

