/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.internal.zzlq;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlu;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzly;
import com.google.android.gms.internal.zzlz;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zzk {
    private static DecimalFormat zzTI;
    private final zzf zzTE;
    private final String zzTJ;
    private final Uri zzTK;
    private final boolean zzTL;
    private final boolean zzTM;

    public zzb(zzf zzf2, String string) {
        this(zzf2, string, true, false);
    }

    public zzb(zzf zzf2, String string, boolean bl, boolean bl2) {
        super(zzf2);
        zzaa.zzdl((String)string);
        this.zzTE = zzf2;
        this.zzTJ = string;
        this.zzTL = bl;
        this.zzTM = bl2;
        this.zzTK = zzb.zzbh(this.zzTJ);
    }

    static Uri zzbh(String string) {
        zzaa.zzdl((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zzkn() {
        return this.zzTK;
    }

    @Override
    public void zzb(com.google.android.gms.analytics.zze zze2) {
        zzaa.zzz((Object)zze2);
        zzaa.zzb((boolean)zze2.zzkD(), (Object)"Can't deliver not submitted measurement");
        zzaa.zzdd((String)"deliver should be called on worker thread");
        com.google.android.gms.analytics.zze zze3 = zze2.zzky();
        zzlw zzlw2 = zze3.zzb(zzlw.class);
        if (TextUtils.isEmpty((CharSequence)zzlw2.zzlr())) {
            this.zzlR().zzh(zzb.zzc(zze3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzlw2.zzku())) {
            this.zzlR().zzh(zzb.zzc(zze3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzTE.zzme().getAppOptOut()) {
            return;
        }
        double d = zzlw2.zzlw();
        if (zzao.zza(d, zzlw2.zzku())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zze3);
        map.put("v", "1");
        map.put("_v", zze.zzWi);
        map.put("tid", this.zzTJ);
        if (this.zzTE.zzme().isDryRunEnabled()) {
            String string = zzb.zzN(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzao.zzc(hashMap, "uid", zzlw2.getUserId());
        zzln zzln2 = zze2.zza(zzln.class);
        if (zzln2 != null) {
            zzao.zzc(hashMap, "an", zzln2.zzkU());
            zzao.zzc(hashMap, "aid", zzln2.zziC());
            zzao.zzc(hashMap, "av", zzln2.zzkV());
            zzao.zzc(hashMap, "aiid", zzln2.zzkW());
        }
        zzh zzh2 = new zzh(0L, zzlw2.zzku(), this.zzTJ, !TextUtils.isEmpty((CharSequence)zzlw2.zzls()), 0L, hashMap);
        long l = this.zzkw().zza(zzh2);
        map.put("_s", String.valueOf(l));
        zzab zzab2 = new zzab(this.zzlR(), map, zze2.zzkB(), true);
        this.zzkw().zza(zzab2);
    }

    public static Map<String, String> zzc(com.google.android.gms.analytics.zze zze2) {
        zzln zzln2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zzlp zzlp2;
        zzlz zzlz2;
        zzly zzly2;
        zzlv zzlv2;
        zzlo zzlo2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzlr zzlr2 = zze2.zza(zzlr.class);
        if (zzlr2 != null) {
            object7 = zzlr2.zzlf().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zzi(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zze2.zza(zzlw.class)) != null) {
            zzb.zzb(hashMap, "t", ((zzlw)object7).zzlr());
            zzb.zzb(hashMap, "cid", ((zzlw)object7).zzku());
            zzb.zzb(hashMap, "uid", ((zzlw)object7).getUserId());
            zzb.zzb(hashMap, "sc", ((zzlw)object7).zzlu());
            zzb.zza(hashMap, "sf", ((zzlw)object7).zzlw());
            zzb.zza(hashMap, "ni", ((zzlw)object7).zzlv());
            zzb.zzb(hashMap, "adid", ((zzlw)object7).zzls());
            zzb.zza(hashMap, "ate", ((zzlw)object7).zzlt());
        }
        if ((object6 = zze2.zza(zzlx.class)) != null) {
            zzb.zzb(hashMap, "cd", ((zzlx)object6).zzly());
            zzb.zza(hashMap, "a", ((zzlx)object6).zzlz());
            zzb.zzb(hashMap, "dr", ((zzlx)object6).zzlA());
        }
        if ((object5 = zze2.zza(zzlu.class)) != null) {
            zzb.zzb(hashMap, "ec", ((zzlu)object5).zzlp());
            zzb.zzb(hashMap, "ea", ((zzlu)object5).getAction());
            zzb.zzb(hashMap, "el", ((zzlu)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzlu)object5).getValue());
        }
        if ((zzlo2 = zze2.zza(zzlo.class)) != null) {
            zzb.zzb(hashMap, "cn", zzlo2.getName());
            zzb.zzb(hashMap, "cs", zzlo2.getSource());
            zzb.zzb(hashMap, "cm", zzlo2.zzkX());
            zzb.zzb(hashMap, "ck", zzlo2.zzkY());
            zzb.zzb(hashMap, "cc", zzlo2.getContent());
            zzb.zzb(hashMap, "ci", zzlo2.getId());
            zzb.zzb(hashMap, "anid", zzlo2.zzkZ());
            zzb.zzb(hashMap, "gclid", zzlo2.zzla());
            zzb.zzb(hashMap, "dclid", zzlo2.zzlb());
            zzb.zzb(hashMap, "aclid", zzlo2.zzlc());
        }
        if ((zzlv2 = zze2.zza(zzlv.class)) != null) {
            zzb.zzb(hashMap, "exd", zzlv2.getDescription());
            zzb.zza(hashMap, "exf", zzlv2.zzlq());
        }
        if ((zzly2 = zze2.zza(zzly.class)) != null) {
            zzb.zzb(hashMap, "sn", zzly2.zzlC());
            zzb.zzb(hashMap, "sa", zzly2.getAction());
            zzb.zzb(hashMap, "st", zzly2.getTarget());
        }
        if ((zzlz2 = zze2.zza(zzlz.class)) != null) {
            zzb.zzb(hashMap, "utv", zzlz2.zzlD());
            zzb.zza(hashMap, "utt", zzlz2.getTimeInMillis());
            zzb.zzb(hashMap, "utc", zzlz2.zzlp());
            zzb.zzb(hashMap, "utl", zzlz2.getLabel());
        }
        if ((zzlp2 = zze2.zza(zzlp.class)) != null) {
            object4 = zzlp2.zzld();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzab((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zze2.zza(zzlq.class)) != null) {
            object3 = ((zzlq)object4).zzle();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzad((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zze2.zza(zzlt.class)) != null) {
            object2 = ((zzlt)object3).zzll();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzlt)object3).zzlo()) {
                hashMap.putAll(promotion.zzbD(com.google.android.gms.analytics.zzc.zzah(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzlt)object3).zzlm()) {
                hashMap.putAll(product.zzbD(com.google.android.gms.analytics.zzc.zzaf(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzlt)object3).zzln().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzak(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(com.google.android.gms.analytics.zzc.zzai(n2));
                    hashMap.putAll(product.zzbD(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zze2.zza(zzls.class)) != null) {
            zzb.zzb(hashMap, "ul", ((zzls)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzls)object2).zzlg());
            zzb.zza(hashMap, "sr", ((zzls)object2).zzlh(), ((zzls)object2).zzli());
            zzb.zza(hashMap, "vp", ((zzls)object2).zzlj(), ((zzls)object2).zzlk());
        }
        if ((zzln2 = zze2.zza(zzln.class)) != null) {
            zzb.zzb(hashMap, "an", zzln2.zzkU());
            zzb.zzb(hashMap, "aid", zzln2.zziC());
            zzb.zzb(hashMap, "aiid", zzln2.zzkW());
            zzb.zzb(hashMap, "av", zzln2.zzkV());
        }
        return hashMap;
    }

    private static void zzb(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zzb(double d) {
        if (zzTI == null) {
            zzTI = new DecimalFormat("0.######");
        }
        return zzTI.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }

    private static String zzN(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zzi(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zzb(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

