/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzao;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzls;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzi {
    private static volatile zzi zzUz;
    private final Context mContext;
    private final List<zzj> zzUA;
    private final zzd zzUB;
    private final zza zzUC;
    private volatile zzln zzUD;
    private Thread.UncaughtExceptionHandler zzUE;

    zzi(Context context) {
        Context context2 = context.getApplicationContext();
        zzaa.zzz((Object)context2);
        this.mContext = context2;
        this.zzUC = new zza();
        this.zzUA = new CopyOnWriteArrayList<zzj>();
        this.zzUB = new zzd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzi zzW(Context context) {
        zzaa.zzz((Object)context);
        if (zzUz != null) return zzUz;
        Class<zzi> clazz = zzi.class;
        synchronized (zzi.class) {
            if (zzUz != null) return zzUz;
            zzUz = new zzi(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzUz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzln zzkL() {
        if (this.zzUD == null) {
            zzi zzi2 = this;
            synchronized (zzi2) {
                if (this.zzUD == null) {
                    zzln zzln2 = new zzln();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzln2.setAppId(string);
                    zzln2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzln2.setAppName(string2);
                    zzln2.setAppVersion(string3);
                    this.zzUD = zzln2;
                }
            }
        }
        return this.zzUD;
    }

    public zzls zzkM() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzls zzls2 = new zzls();
        zzls2.setLanguage(zzao.zza(Locale.getDefault()));
        zzls2.zzao(displayMetrics.widthPixels);
        zzls2.zzap(displayMetrics.heightPixels);
        return zzls2;
    }

    void zze(zze zze2) {
        if (zze2.zzkH()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zze2.zzkD()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final zze zze3 = zze2.zzky();
        zze3.zzkE();
        this.zzUC.execute(new Runnable(){

            @Override
            public void run() {
                zzh zzh2 = zze3.zzkF();
                zzh2.zza(zze3);
                for (zzj zzj2 : zzi.this.zzUA) {
                    zzj2.zza(zze3);
                }
                zzi.this.zzb(zze3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzkN() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzUE = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzc(Callable<V> callable) {
        zzaa.zzz(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzUC.submit(callable);
    }

    public void zzf(Runnable runnable) {
        zzaa.zzz((Object)runnable);
        this.zzUC.submit(runnable);
    }

    private void zzb(zze zze2) {
        zzaa.zzdd((String)"deliver should be called from worker thread");
        zzaa.zzb((boolean)zze2.zzkD(), (Object)"Measurement must be submitted");
        List<zzk> list = zze2.zzkA();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzk zzk2 : list) {
            Uri uri = zzk2.zzkn();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzk2.zzb(zze2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzUI = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            int n = zzUI.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new FutureTask<T>(runnable, t){

                @Override
                protected void setException(Throwable throwable) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzi.this.zzUE;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        String string = String.valueOf(throwable);
                        Log.e((String)"GAv4", (String)new StringBuilder(37 + String.valueOf(string).length()).append("MeasurementExecutor: job failed with ").append(string).toString());
                    }
                    super.setException(throwable);
                }
            };
        }
    }
}

