/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.tagmanager.zzac;
import com.google.android.gms.tagmanager.zzam;
import com.google.android.gms.tagmanager.zzar;
import com.google.android.gms.tagmanager.zzav;
import com.google.android.gms.tagmanager.zzaw;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzdb;
import com.google.android.gms.tagmanager.zzde;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class zzcf
implements zzav {
    private static final String zzWN = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final zzb zzbpP;
    private volatile zzac zzbpQ;
    private final zzaw zzbpR;
    private final Context mContext;
    private final String zzbpS;
    private long zzbpT;
    private zze zzsd;
    private final int zzbpU;

    zzcf(zzaw zzaw2, Context context) {
        this(zzaw2, context, "gtm_urls.db", 2000);
    }

    zzcf(zzaw zzaw2, Context context, String string, int n) {
        this.mContext = context.getApplicationContext();
        this.zzbpS = string;
        this.zzbpR = zzaw2;
        this.zzsd = zzh.zzuW();
        this.zzbpP = new zzb(this.mContext, this.zzbpS);
        this.zzbpQ = new zzde(this.mContext, new zza());
        this.zzbpT = 0L;
        this.zzbpU = n;
    }

    @Override
    public void zzg(long l, String string) {
        this.zzms();
        this.zzKd();
        this.zzh(l, string);
    }

    private void zzKd() {
        int n = this.zzKe() - this.zzbpU + 1;
        if (n > 0) {
            List<String> list = this.zzkU(n);
            int n2 = list.size();
            zzbn.v(new StringBuilder(51).append("Store full, deleting ").append(n2).append(" hits to make room.").toString());
            this.zzh(list.toArray(new String[0]));
        }
    }

    private void zzh(long l, String string) {
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l));
        contentValues.put("hit_url", string);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.zzbpR.zzaE(false);
        }
        catch (SQLiteException sQLiteException) {
            zzbn.zzaW("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> zzkU(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbn.zzaW("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzar> zzkV(int n) {
        ArrayList<zzar> arrayList = new ArrayList<zzar>();
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    zzar zzar2 = new zzar(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(zzar2);
                } while (cursor.moveToNext());
            }
        }
        int n2 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((zzar)arrayList.get(n2)).zzgz(cursor.getString(1));
                    } else {
                        zzbn.zzaW(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((zzar)arrayList.get(n2)).zzJQ()));
                    }
                    ++n2;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            String string = String.valueOf(sQLiteException.getMessage());
            zzbn.zzaW(string.length() != 0 ? "Error in peekHits fetching hit url: ".concat(string) : new String("Error in peekHits fetching hit url: "));
            ArrayList<zzar> arrayList2 = new ArrayList<zzar>();
            boolean bl = false;
            for (zzar zzar3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)zzar3.zzJS())) {
                    if (bl) break;
                    bl = true;
                }
                arrayList2.add(zzar3);
            }
            ArrayList<zzar> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int zzms() {
        long l = this.zzsd.currentTimeMillis();
        if (l <= this.zzbpT + 86400000L) {
            return 0;
        }
        this.zzbpT = l;
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l2 = this.zzsd.currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l2)});
        this.zzbpR.zzaE(this.zzKe() == 0);
        return n;
    }

    void zzh(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string, stringArray);
            this.zzbpR.zzaE(this.zzKe() == 0);
        }
        catch (SQLiteException sQLiteException) {
            zzbn.zzaW("Error deleting hits");
        }
    }

    private void zzs(long l) {
        this.zzh(new String[]{String.valueOf(l)});
    }

    private void zzd(long l, long l2) {
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l2));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l)});
        }
        catch (SQLiteException sQLiteException) {
            zzbn.zzaW(new StringBuilder(69).append("Error setting HIT_FIRST_DISPATCH_TIME for hitId: ").append(l).toString());
            this.zzs(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzKe() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzKf() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n = cursor.getCount();
        }
        return n;
    }

    @Override
    public void dispatch() {
        zzbn.v("GTM Dispatch running...");
        if (!this.zzbpQ.zzJF()) {
            return;
        }
        List<zzar> list = this.zzkV(40);
        if (list.isEmpty()) {
            zzbn.v("...nothing to dispatch");
            this.zzbpR.zzaE(true);
            return;
        }
        this.zzbpQ.zzI(list);
        if (this.zzKf() > 0) {
            zzdb.zzKB().dispatch();
        }
    }

    private SQLiteDatabase zzgv(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzbpP.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbn.zzaW(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class zzb
    extends SQLiteOpenHelper {
        private boolean zzbpW;
        private long zzbpX;

        zzb(Context context, String string) {
            super(context, string, null, 1);
            this.zzbpX = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.zzbpW && this.zzbpX + 3600000L > zzcf.this.zzsd.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.zzbpW = true;
            this.zzbpX = zzcf.this.zzsd.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzcf.this.mContext.getDatabasePath(zzcf.this.zzbpS).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.zzbpW = false;
            return sQLiteDatabase;
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("gtm_hits", sQLiteDatabase)) {
                sQLiteDatabase.execSQL(zzWN);
            } else {
                this.zzc(sQLiteDatabase);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zzc(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzam.zzbR(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    class zza
    implements zzde.zza {
        zza() {
        }

        @Override
        public void zza(zzar zzar2) {
            zzcf.this.zzs(zzar2.zzJQ());
        }

        @Override
        public void zzb(zzar zzar2) {
            zzcf.this.zzs(zzar2.zzJQ());
            long l = zzar2.zzJQ();
            zzbn.v(new StringBuilder(57).append("Permanent failure dispatching hitId: ").append(l).toString());
        }

        @Override
        public void zzc(zzar zzar2) {
            long l = zzar2.zzJR();
            if (l == 0L) {
                zzcf.this.zzd(zzar2.zzJQ(), zzcf.this.zzsd.currentTimeMillis());
            } else if (l + 14400000L < zzcf.this.zzsd.currentTimeMillis()) {
                zzcf.this.zzs(zzar2.zzJQ());
                long l2 = zzar2.zzJQ();
                zzbn.v(new StringBuilder(47).append("Giving up on failed hitId: ").append(l2).toString());
            }
        }
    }
}

