/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzabr;
import com.google.android.gms.internal.zzabt;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbm;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzci;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcu
implements zzp.zzf {
    private final Context mContext;
    private final String zzbnR;
    private final ExecutorService zzbqx;
    private zzbm<zzabr.zza> zzbqr;

    zzcu(Context context, String string) {
        this.mContext = context;
        this.zzbnR = string;
        this.zzbqx = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbm<zzabr.zza> zzbm2) {
        this.zzbqr = zzbm2;
    }

    @Override
    public void zzJu() {
        this.zzbqx.execute(new Runnable(){

            @Override
            public void run() {
                zzcu.this.zzKp();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzKp() {
        if (this.zzbqr == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzbqr.zzJt();
        zzbn.v("Attempting to load resource from disk");
        if ((zzci.zzKh().zzKi() == zzci.zza.zzbqg || zzci.zzKh().zzKi() == zzci.zza.zzbqh) && this.zzbnR.equals(zzci.zzKh().getContainerId())) {
            this.zzbqr.zza(zzbm.zza.zzbpF);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzKq());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbn.zzaU("Failed to find the resource in the disk");
            this.zzbqr.zza(zzbm.zza.zzbpF);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzabt.zzc(fileInputStream, byteArrayOutputStream);
            zzabr.zza zza2 = zzabr.zza.zzD((byte[])byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzbqr.onSuccess(zza2);
        }
        catch (IOException iOException) {
            this.zzbqr.zza(zzbm.zza.zzbpG);
            zzbn.zzaW("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzbqr.zza(zzbm.zza.zzbpG);
            zzbn.zzaW("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbn.zzaW("Error closing stream for reading resource from disk");
            }
        }
        zzbn.v("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzabr.zza zza2) {
        this.zzbqx.execute(new Runnable(){

            @Override
            public void run() {
                zzcu.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzabt.zzc zzkN(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbn.zzaW(new StringBuilder(98).append("Failed to load the container. No default container resource found with the resource ID ").append(n).toString());
            return null;
        }
        Object object = String.valueOf(this.mContext.getResources().getResourceName(n));
        zzbn.v(new StringBuilder(66 + String.valueOf(object).length()).append("Attempting to load a container from the resource ID ").append(n).append(" (").append((String)object).append(")").toString());
        try {
            object = new ByteArrayOutputStream();
            zzabt.zzc(inputStream, (OutputStream)object);
            zzabt.zzc zzc2 = this.zza((ByteArrayOutputStream)object);
            if (zzc2 != null) {
                zzbn.v("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzz(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (IOException iOException) {
            String string = String.valueOf(this.mContext.getResources().getResourceName(n));
            zzbn.zzaW(new StringBuilder(67 + String.valueOf(string).length()).append("Error reading the default container with resource ID ").append(n).append(" (").append(string).append(")").toString());
            return null;
        }
    }

    private zzabt.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzbg.zzgC(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbn.zzaU("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbn.zzaW("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzabt.zzc zzz(byte[] byArray) {
        try {
            zzabt.zzc zzc2 = zzabt.zzb(zzaf.zzf.zzc((byte[])byArray));
            if (zzc2 != null) {
                zzbn.v("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzami zzami2) {
            zzbn.e("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzabt.zzg zzg2) {
            zzbn.zzaW("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzbqx.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzabr.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzKq();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbn.e("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzamj.toByteArray((zzamj)zza2));
            boolean bl = true;
            return true;
        }
        catch (IOException iOException) {
            zzbn.zzaW("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbn.zzaW("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzKq() {
        String string = String.valueOf("resource_");
        String string2 = String.valueOf(this.zzbnR);
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string3);
    }

    private void zzd(zzabr.zza zza2) throws IllegalArgumentException {
        if (zza2.zzjG == null && zza2.zzbwa == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

