/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzdi;
import com.google.android.gms.tagmanager.zzdj;
import com.google.android.gms.tagmanager.zzdl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzdm
extends zzdj {
    private static final String ID = zzad.zzdc.toString();
    private static final String zzbrP = zzae.zzdL.toString();
    private static final String zzbrQ = zzae.zzdW.toString();
    private static final String zzbrR = zzae.zzft.toString();
    private static final String zzbrS = zzae.zzfn.toString();
    private static final String zzbrT = zzae.zzfm.toString();
    private static final String zzbrU = zzae.zzdV.toString();
    private static final String zzbrV = zzae.zzia.toString();
    private static final String zzbrW = zzae.zzid.toString();
    private static final String zzbrX = zzae.zzif.toString();
    private static final List<String> zzbrY = Arrays.asList("detail", "checkout", "checkout_option", "click", "add", "remove", "purchase", "refund");
    private static final Pattern zzbrZ = Pattern.compile("dimension(\\d+)");
    private static final Pattern zzbsa = Pattern.compile("metric(\\d+)");
    private static Map<String, String> zzbsb;
    private static Map<String, String> zzbsc;
    private final Set<String> zzbsd;
    private final zzdi zzbse;
    private final DataLayer zzbnS;

    public zzdm(Context context, DataLayer dataLayer) {
        this(context, dataLayer, new zzdi(context));
    }

    zzdm(Context context, DataLayer dataLayer, zzdi zzdi2) {
        super(ID, new String[0]);
        this.zzbnS = dataLayer;
        this.zzbse = zzdi2;
        this.zzbsd = new HashSet<String>();
        this.zzbsd.add("");
        this.zzbsd.add("0");
        this.zzbsd.add("false");
    }

    private boolean zzj(Map<String, zzag.zza> map, String string) {
        zzag.zza zza2 = map.get(string);
        return zza2 == null ? false : zzdl.zzk(zza2);
    }

    @Override
    public void zzX(Map<String, zzag.zza> map) {
        Tracker tracker = this.zzbse.zzgK("_GTM_DEFAULT_TRACKER_");
        tracker.enableAdvertisingIdCollection(this.zzj(map, "collect_adid"));
        if (this.zzj(map, zzbrR)) {
            this.zzb(tracker, map);
        } else if (this.zzj(map, zzbrQ)) {
            tracker.send(this.zzm(map.get(zzbrU)));
        } else if (this.zzj(map, zzbrV)) {
            this.zza(tracker, map);
        } else {
            zzbn.zzaW("Ignoring unknown tag.");
        }
    }

    private String zzgS(String string) {
        Object object = this.zzbnS.get(string);
        return object == null ? null : object.toString();
    }

    private List<Map<String, String>> zzgT(String string) {
        Object object = this.zzbnS.get(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("transactionProducts should be of type List.");
        }
        List list = (List)object;
        for (Object e : list) {
            if (e instanceof Map) continue;
            throw new IllegalArgumentException("Each element of transactionProducts should be of type Map.");
        }
        List list2 = (List)object;
        return list2;
    }

    private void zze(Map<String, String> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    private void zza(Tracker tracker, Map<String, zzag.zza> map) {
        String string = this.zzgS("transactionId");
        if (string == null) {
            zzbn.e("Cannot find transactionId in data layer.");
            return;
        }
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        try {
            Map<String, String> map2 = this.zzm(map.get(zzbrU));
            map2.put("&t", "transaction");
            Map<String, String> map3 = this.zzah(map);
            for (Map.Entry<String, String> iterator : map3.entrySet()) {
                this.zze(map2, iterator.getValue(), this.zzgS(iterator.getKey()));
            }
            linkedList.add(map2);
            List<Map<String, String>> list = this.zzgT("transactionProducts");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map map4 = (Map)iterator.next();
                    if (map4.get("name") == null) {
                        zzbn.e("Unable to send transaction item hit due to missing 'name' field.");
                        return;
                    }
                    Map<String, String> map5 = this.zzm(map.get(zzbrU));
                    map5.put("&t", "item");
                    map5.put("&ti", string);
                    Map<String, String> map6 = this.zzai(map);
                    for (Map.Entry<String, String> entry : map6.entrySet()) {
                        this.zze(map5, entry.getValue(), (String)map4.get(entry.getKey()));
                    }
                    linkedList.add(map5);
                }
            }
            for (Map map7 : linkedList) {
                tracker.send(map7);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzbn.zzb("Unable to send transaction", illegalArgumentException);
            return;
        }
    }

    private void zzb(Tracker tracker, Map<String, zzag.zza> map) {
        Object object;
        HitBuilders.ScreenViewBuilder screenViewBuilder = new HitBuilders.ScreenViewBuilder();
        Map<String, String> map2 = this.zzm(map.get(zzbrU));
        screenViewBuilder.setAll(map2);
        Map map3 = null;
        if (this.zzj(map, zzbrS)) {
            object = this.zzbnS.get("ecommerce");
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        } else {
            object = zzdl.zzl(map.get(zzbrT));
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        }
        if (map3 != null) {
            Object object2;
            Object object3;
            List list;
            Object v;
            object = map2.get("&cu");
            if (object == null) {
                object = (String)map3.get("currencyCode");
            }
            if (object != null) {
                screenViewBuilder.set("&cu", (String)object);
            }
            if ((v = map3.get("impressions")) instanceof List) {
                list = (List)v;
                for (Iterator<String> iterator : list) {
                    try {
                        Product runtimeException = this.zzag((Map<String, Object>)((Object)iterator));
                        screenViewBuilder.addImpression(runtimeException, (String)iterator.get("list"));
                    }
                    catch (RuntimeException runtimeException) {
                        String string = String.valueOf(runtimeException.getMessage());
                        zzbn.e(string.length() != 0 ? "Failed to extract a product from DataLayer. ".concat(string) : new String("Failed to extract a product from DataLayer. "));
                    }
                }
            }
            list = null;
            if (map3.containsKey("promoClick")) {
                object3 = (Map)map3.get("promoClick");
                list = (List)object3.get("promotions");
            } else if (map3.containsKey("promoView")) {
                object3 = (Map)map3.get("promoView");
                list = (List)object3.get("promotions");
            }
            boolean bl = true;
            if (list != null) {
                for (Map map4 : list) {
                    try {
                        object2 = this.zzaf(map4);
                        screenViewBuilder.addPromotion((Promotion)object2);
                    }
                    catch (RuntimeException runtimeException) {
                        String string = String.valueOf(runtimeException.getMessage());
                        zzbn.e(string.length() != 0 ? "Failed to extract a promotion from DataLayer. ".concat(string) : new String("Failed to extract a promotion from DataLayer. "));
                    }
                }
                if (map3.containsKey("promoClick")) {
                    screenViewBuilder.set("&promoa", "click");
                    bl = false;
                } else {
                    screenViewBuilder.set("&promoa", "view");
                }
            }
            if (bl) {
                for (String string : zzbrY) {
                    if (!map3.containsKey(string)) continue;
                    object2 = (Map)map3.get(string);
                    List list2 = (List)object2.get("products");
                    if (list2 != null) {
                        for (Map map5 : list2) {
                            try {
                                Product product = this.zzag(map5);
                                screenViewBuilder.addProduct(product);
                            }
                            catch (RuntimeException runtimeException) {
                                String string2 = String.valueOf(runtimeException.getMessage());
                                zzbn.e(string2.length() != 0 ? "Failed to extract a product from DataLayer. ".concat(string2) : new String("Failed to extract a product from DataLayer. "));
                            }
                        }
                    }
                    try {
                        Object object4;
                        if (object2.containsKey("actionField")) {
                            Map map5;
                            map5 = (Map)object2.get("actionField");
                            object4 = this.zzg(string, map5);
                        } else {
                            object4 = new ProductAction(string);
                        }
                        screenViewBuilder.setProductAction((ProductAction)object4);
                    }
                    catch (RuntimeException runtimeException) {
                        String string3 = String.valueOf(runtimeException.getMessage());
                        zzbn.e(string3.length() != 0 ? "Failed to extract a product action from DataLayer. ".concat(string3) : new String("Failed to extract a product action from DataLayer. "));
                    }
                    break;
                }
            }
        }
        tracker.send(screenViewBuilder.build());
    }

    private ProductAction zzg(String string, Map<String, Object> map) {
        ProductAction productAction = new ProductAction(string);
        Object object = map.get("id");
        if (object != null) {
            productAction.setTransactionId(String.valueOf(object));
        }
        if ((object = map.get("affiliation")) != null) {
            productAction.setTransactionAffiliation(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            productAction.setTransactionCouponCode(String.valueOf(object));
        }
        if ((object = map.get("list")) != null) {
            productAction.setProductActionList(String.valueOf(object));
        }
        if ((object = map.get("option")) != null) {
            productAction.setCheckoutOptions(String.valueOf(object));
        }
        if ((object = map.get("revenue")) != null) {
            productAction.setTransactionRevenue(this.zzU(object));
        }
        if ((object = map.get("tax")) != null) {
            productAction.setTransactionTax(this.zzU(object));
        }
        if ((object = map.get("shipping")) != null) {
            productAction.setTransactionShipping(this.zzU(object));
        }
        if ((object = map.get("step")) != null) {
            productAction.setCheckoutStep(this.zzV(object));
        }
        return productAction;
    }

    private Promotion zzaf(Map<String, String> map) {
        Promotion promotion = new Promotion();
        String string = map.get("id");
        if (string != null) {
            promotion.setId(String.valueOf(string));
        }
        if ((string = map.get("name")) != null) {
            promotion.setName(String.valueOf(string));
        }
        if ((string = map.get("creative")) != null) {
            promotion.setCreative(String.valueOf(string));
        }
        if ((string = map.get("position")) != null) {
            promotion.setPosition(String.valueOf(string));
        }
        return promotion;
    }

    private Product zzag(Map<String, Object> map) {
        Product product = new Product();
        Object object = map.get("id");
        if (object != null) {
            product.setId(String.valueOf(object));
        }
        if ((object = map.get("name")) != null) {
            product.setName(String.valueOf(object));
        }
        if ((object = map.get("brand")) != null) {
            product.setBrand(String.valueOf(object));
        }
        if ((object = map.get("category")) != null) {
            product.setCategory(String.valueOf(object));
        }
        if ((object = map.get("variant")) != null) {
            product.setVariant(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            product.setCouponCode(String.valueOf(object));
        }
        if ((object = map.get("position")) != null) {
            product.setPosition(this.zzV(object));
        }
        if ((object = map.get("price")) != null) {
            product.setPrice(this.zzU(object));
        }
        if ((object = map.get("quantity")) != null) {
            product.setQuantity(this.zzV(object));
        }
        for (String string : map.keySet()) {
            Matcher matcher = zzbrZ.matcher(string);
            if (matcher.matches()) {
                int n = 0;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = String.valueOf(string);
                    zzbn.zzaW(string2.length() != 0 ? "illegal number in custom dimension value: ".concat(string2) : new String("illegal number in custom dimension value: "));
                    continue;
                }
                product.setCustomDimension(n, String.valueOf(map.get(string)));
                continue;
            }
            Matcher matcher2 = zzbsa.matcher(string);
            if (!matcher2.matches()) continue;
            int n = 0;
            try {
                n = Integer.parseInt(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = String.valueOf(string);
                zzbn.zzaW(string3.length() != 0 ? "illegal number in custom metric value: ".concat(string3) : new String("illegal number in custom metric value: "));
                continue;
            }
            product.setCustomMetric(n, this.zzV(map.get(string)));
        }
        return product;
    }

    private Map<String, String> zzc(zzag.zza zza2) {
        Object object = zzdl.zzl(zza2);
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return linkedHashMap;
    }

    private Map<String, String> zzm(zzag.zza zza2) {
        if (zza2 == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> map = this.zzc(zza2);
        if (map == null) {
            return new HashMap<String, String>();
        }
        String string = map.get("&aip");
        if (string != null && this.zzbsd.contains(string.toLowerCase())) {
            map.remove("&aip");
        }
        return map;
    }

    private Map<String, String> zzah(Map<String, zzag.zza> map) {
        zzag.zza zza2 = map.get(zzbrW);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (zzbsb == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("transactionId", "&ti");
            hashMap.put("transactionAffiliation", "&ta");
            hashMap.put("transactionTax", "&tt");
            hashMap.put("transactionShipping", "&ts");
            hashMap.put("transactionTotal", "&tr");
            hashMap.put("transactionCurrency", "&cu");
            zzbsb = hashMap;
        }
        return zzbsb;
    }

    private Map<String, String> zzai(Map<String, zzag.zza> map) {
        zzag.zza zza2 = map.get(zzbrX);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (zzbsc == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "&in");
            hashMap.put("sku", "&ic");
            hashMap.put("category", "&iv");
            hashMap.put("price", "&ip");
            hashMap.put("quantity", "&iq");
            hashMap.put("currency", "&cu");
            zzbsc = hashMap;
        }
        return zzbsc;
    }

    private Double zzU(Object object) {
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(numberFormatException.getMessage());
                throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Double: ".concat(string) : new String("Cannot convert the object to Double: "));
            }
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = String.valueOf(object.toString());
        throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Double: ".concat(string) : new String("Cannot convert the object to Double: "));
    }

    private Integer zzV(Object object) {
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(numberFormatException.getMessage());
                throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Integer: ".concat(string) : new String("Cannot convert the object to Integer: "));
            }
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        String string = String.valueOf(object.toString());
        throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Integer: ".concat(string) : new String("Cannot convert the object to Integer: "));
    }
}

