/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzam;
import com.google.android.gms.tagmanager.zzbn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class zzw
implements DataLayer.zzc {
    private static final String zzboG = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' STRING NOT NULL, '%s' BLOB NOT NULL, '%s' INTEGER NOT NULL);", "datalayer", "ID", "key", "value", "expires");
    private final Executor zzboH;
    private final Context mContext;
    private zza zzboI;
    private zze zzsd;
    private int zzboJ;

    public zzw(Context context) {
        this(context, zzh.zzuW(), "google_tagmanager.db", 2000, Executors.newSingleThreadExecutor());
    }

    zzw(Context context, zze zze2, String string, int n, Executor executor) {
        this.mContext = context;
        this.zzsd = zze2;
        this.zzboJ = n;
        this.zzboH = executor;
        this.zzboI = new zza(this.mContext, string);
    }

    @Override
    public void zza(List<DataLayer.zza> list, final long l) {
        final List<zzb> list2 = this.zzH(list);
        this.zzboH.execute(new Runnable(){

            @Override
            public void run() {
                zzw.this.zzb(list2, l);
            }
        });
    }

    @Override
    public void zza(final DataLayer.zzc.zza zza2) {
        this.zzboH.execute(new Runnable(){

            @Override
            public void run() {
                zza2.zzF(zzw.this.zzJA());
            }
        });
    }

    @Override
    public void zzgt(final String string) {
        this.zzboH.execute(new Runnable(){

            @Override
            public void run() {
                zzw.this.zzgu(string);
            }
        });
    }

    private List<DataLayer.zza> zzJA() {
        try {
            this.zzaq(this.zzsd.currentTimeMillis());
            List<DataLayer.zza> list = this.zzG(this.zzJB());
            return list;
        }
        finally {
            this.zzJD();
        }
    }

    private List<DataLayer.zza> zzG(List<zzb> list) {
        ArrayList<DataLayer.zza> arrayList = new ArrayList<DataLayer.zza>();
        for (zzb zzb2 : list) {
            arrayList.add(new DataLayer.zza(zzb2.zzwQ, this.zzy(zzb2.zzboP)));
        }
        return arrayList;
    }

    private List<zzb> zzH(List<DataLayer.zza> list) {
        ArrayList<zzb> arrayList = new ArrayList<zzb>();
        for (DataLayer.zza zza2 : list) {
            arrayList.add(new zzb(zza2.zzwQ, this.zzI(zza2.zzRF)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object zzy(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            Object var5_8 = null;
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object var5_9 = null;
            return null;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzI(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            Object var5_7 = null;
            return null;
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void zzb(List<zzb> list, long l) {
        try {
            long l2 = this.zzsd.currentTimeMillis();
            this.zzaq(l2);
            this.zzkO(list.size());
            this.zzc(list, l2 + l);
        }
        finally {
            this.zzJD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<zzb> zzJB() {
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for loadSerialized.");
        ArrayList<zzb> arrayList = new ArrayList<zzb>();
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        String[] stringArray = new String[]{"key", "value"};
        try (Cursor cursor = sQLiteDatabase.query("datalayer", stringArray, null, null, null, null, "ID", null);){
            while (cursor.moveToNext()) {
                arrayList.add(new zzb(cursor.getString(0), cursor.getBlob(1)));
            }
        }
        return arrayList;
    }

    private void zzc(List<zzb> list, long l) {
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for writeEntryToDatabase.");
        if (sQLiteDatabase == null) {
            return;
        }
        for (zzb zzb2 : list) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("expires", Long.valueOf(l));
            contentValues.put("key", zzb2.zzwQ);
            contentValues.put("value", zzb2.zzboP);
            sQLiteDatabase.insert("datalayer", null, contentValues);
        }
    }

    private void zzkO(int n) {
        int n2 = this.zzJC() - this.zzboJ + n;
        if (n2 > 0) {
            List<String> list = this.zzkP(n2);
            int n3 = list.size();
            zzbn.zzaV(new StringBuilder(64).append("DataLayer store full, deleting ").append(n3).append(" entries to make room.").toString());
            this.zzg(list.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzgu(String string) {
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for clearKeysWithPrefix.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n = sQLiteDatabase.delete("datalayer", "key = ? OR key LIKE ?", new String[]{string, String.valueOf(string).concat(".%")});
            zzbn.v(new StringBuilder(25).append("Cleared ").append(n).append(" items").toString());
        }
        catch (SQLiteException sQLiteException) {
            String string2 = String.valueOf((Object)sQLiteException);
            zzbn.zzaW(new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Error deleting entries with key prefix: ").append(string).append(" (").append(string2).append(").").toString());
        }
        finally {
            this.zzJD();
        }
    }

    private void zzaq(long l) {
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for deleteOlderThan.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n = sQLiteDatabase.delete("datalayer", "expires <= ?", new String[]{Long.toString(l)});
            zzbn.v(new StringBuilder(33).append("Deleted ").append(n).append(" expired items").toString());
        }
        catch (SQLiteException sQLiteException) {
            zzbn.zzaW("Error deleting old entries.");
        }
    }

    private void zzg(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for deleteEntries.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("%s in (%s)", "ID", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("datalayer", string, stringArray);
        }
        catch (SQLiteException sQLiteException) {
            String string2 = String.valueOf(Arrays.toString(stringArray));
            zzbn.zzaW(string2.length() != 0 ? "Error deleting entries ".concat(string2) : new String("Error deleting entries "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> zzkP(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbn.zzaW("Invalid maxEntries specified. Skipping.");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for peekEntryIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("datalayer", new String[]{"ID"}, null, null, null, null, String.format("%s ASC", "ID"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzJC() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzgv("Error opening database for getNumStoredEntries.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from datalayer", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    private SQLiteDatabase zzgv(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzboI.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbn.zzaW(string);
            return null;
        }
        return sQLiteDatabase;
    }

    private void zzJD() {
        try {
            this.zzboI.close();
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
    }

    private static class zzb {
        final String zzwQ;
        final byte[] zzboP;

        zzb(String string, byte[] byArray) {
            this.zzwQ = string;
            this.zzboP = byArray;
        }

        public String toString() {
            String string = this.zzwQ;
            int n = Arrays.hashCode(this.zzboP);
            return new StringBuilder(54 + String.valueOf(string).length()).append("KeyAndSerialized: key = ").append(string).append(" serialized hash = ").append(n).toString();
        }
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            SQLiteDatabase sQLiteDatabase = null;
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzw.this.mContext.getDatabasePath("google_tagmanager.db").delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            return sQLiteDatabase;
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("datalayer", sQLiteDatabase)) {
                sQLiteDatabase.execSQL(zzboG);
            } else {
                this.zzc(sQLiteDatabase);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zzc(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM datalayer WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("key") && hashSet.remove("value") && hashSet.remove("ID") && hashSet.remove("expires"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzam.zzbR(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }
}

