/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.common.internal.zzv;

class zzaf
extends BroadcastReceiver {
    static final String zzIs = zzaf.class.getName();
    private final zze zzFD;
    private boolean zzIt;
    private boolean zzIu;

    zzaf(zze zze2) {
        zzv.zzr((Object)zze2);
        this.zzFD = zze2;
    }

    public void onReceive(Context ctx, Intent intent) {
        this.zziX();
        String string = intent.getAction();
        this.zzFD.zzgH().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zziZ();
            if (this.zzIu != bl) {
                this.zzIu = bl;
                this.zzfZ().zzG(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzIs)) {
                this.zzfZ().zzgA();
            }
            return;
        }
        this.zzFD.zzgH().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zziW() {
        this.zziX();
        if (this.zzIt) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzIu = this.zziZ();
        this.zzFD.zzgH().zza("Registering connectivity change receiver. Network connected", this.zzIu);
        this.zzIt = true;
    }

    private void zziX() {
        this.zzgH();
        this.zzfZ();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzFD.zzgH().zzaF("Unregistering connectivity change receiver");
        this.zzIt = false;
        this.zzIu = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzgH().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zziY() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzIs, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzIt;
    }

    public boolean isConnected() {
        if (!this.zzIt) {
            this.zzFD.zzgH().zzaI("Connectivity unknown. Receiver not registered");
        }
        return this.zzIu;
    }

    protected boolean zziZ() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzFD.getContext();
    }

    private zzae zzgH() {
        return this.zzFD.zzgH();
    }

    private zzb zzfZ() {
        return this.zzFD.zzfZ();
    }
}

