/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaa;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzl;
import com.google.android.gms.analytics.internal.zzn;
import com.google.android.gms.common.internal.zzv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

class zzag
extends zzd {
    private final String zzBW = zzag.zza("GoogleAnalytics", "4.5.0", Build.VERSION.RELEASE, zzal.zza(Locale.getDefault()), Build.MODEL, Build.ID);
    private final zzai zzIv;
    private static final byte[] zzIw = "\n".getBytes();

    zzag(zze zze2) {
        super(zze2);
        this.zzIv = new zzai(zze2.zzgG());
    }

    @Override
    protected void zzgb() {
        this.zza("Network initialized. User agent", this.zzBW);
    }

    private static String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    public boolean zziZ() {
        this.zzgF();
        this.zzgR();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzaF("No network connectivity");
            return false;
        }
        return true;
    }

    public List<Long> zzg(List<zzaa> list) {
        boolean bl;
        boolean bl2;
        this.zzgF();
        this.zzgR();
        zzv.zzr(list);
        if (this.zzgI().zzij().isEmpty() || !this.zzIv.zzt(this.zzgI().zzic() * 1000L)) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = this.zzgI().zzih() != zzl.zzGD;
            boolean bl3 = bl = this.zzgI().zzii() == zzn.zzGP;
        }
        if (bl2) {
            return this.zza(list, bl);
        }
        return this.zzh(list);
    }

    List<Long> zzh(List<zzaa> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
        for (zzaa zzaa2 : list) {
            if (!this.zzg(zzaa2)) break;
            arrayList.add(zzaa2.zziO());
            if (arrayList.size() < this.zzgI().zzia()) continue;
            break;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zza(URL uRL) {
        zzv.zzr((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.connect();
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzfZ().zzgB();
            }
            this.zzb("GET status", n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            int n = 0;
            return n;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zza(URL uRL, byte[] byArray) {
        zzv.zzr((Object)uRL);
        zzv.zzr((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (this.zzgQ()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzfZ().zzgB();
            }
            this.zzb("POST status", n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            int n = 0;
            return n;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static byte[] zze(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL, byte[] byArray) {
        zzv.zzr((Object)uRL);
        zzv.zzr((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            byte[] byArray2 = zzag.zze(byArray);
            this.zza("POST compressed size, ratio %, url", byArray2.length, 100L * (long)byArray2.length / (long)byArray.length, uRL);
            if (byArray2.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray2.length, byArray.length);
            }
            if (this.zzgQ()) {
                this.zza("Post payload", "\n" + new String(byArray));
            }
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray2.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            this.zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzfZ().zzgB();
            }
            this.zzb("POST status", n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            int n = 0;
            return n;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http connection input stream", iOException);
                }
            }
        }
    }

    HttpURLConnection zzb(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(this.zzgI().zzis());
        httpURLConnection.setReadTimeout(this.zzgI().zzit());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzBW);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private boolean zzg(zzaa zzaa2) {
        zzv.zzr((Object)zzaa2);
        String string = this.zza(zzaa2, !zzaa2.zziR());
        if (string == null) {
            this.zzgH().zza(zzaa2, "Error formatting hit for upload");
            return true;
        }
        if (string.length() <= this.zzgI().zzhS()) {
            URL uRL = this.zzb(zzaa2, string);
            if (uRL == null) {
                this.zzaJ("Failed to build collect GET endpoint url");
                return false;
            }
            return this.zza(uRL) == 200;
        }
        string = this.zza(zzaa2, false);
        if (string == null) {
            this.zzgH().zza(zzaa2, "Error formatting hit for POST upload");
            return true;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length > this.zzgI().zzhU()) {
            this.zzgH().zza(zzaa2, "Hit payload exceeds size limit");
            return true;
        }
        URL uRL = this.zzh(zzaa2);
        if (uRL == null) {
            this.zzaJ("Failed to build collect POST endpoint url");
            return false;
        }
        return this.zza(uRL, byArray) == 200;
    }

    List<Long> zza(List<zzaa> list, boolean bl) {
        zzv.zzQ((!list.isEmpty() ? 1 : 0) != 0);
        this.zza("Uploading batched hits. compression, count", bl, list.size());
        zza zza2 = new zza();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (zzaa zzaa2 : list) {
            if (!zza2.zzj(zzaa2)) break;
            arrayList.add(zzaa2.zziO());
        }
        if (zza2.zzjc() == 0) {
            return arrayList;
        }
        URL uRL = this.zzja();
        if (uRL == null) {
            this.zzaJ("Failed to build batching endpoint url");
            return Collections.emptyList();
        }
        int n = bl ? this.zzb(uRL, zza2.getPayload()) : this.zza(uRL, zza2.getPayload());
        if (200 == n) {
            this.zza("Batched upload completed. Hits batched", zza2.zzjc());
            return arrayList;
        }
        this.zza("Network error uploading hits. status code", n);
        if (this.zzgI().zzij().contains(n)) {
            this.zzaI("Server instructed the client to stop batching");
            this.zzIv.start();
        }
        return Collections.emptyList();
    }

    private URL zzh(zzaa zzaa2) {
        String string = zzaa2.zziR() ? this.zzgI().zzid() + this.zzgI().zzif() : this.zzgI().zzie() + this.zzgI().zzif();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzb(zzaa zzaa2, String string) {
        String string2 = zzaa2.zziR() ? this.zzgI().zzid() + this.zzgI().zzif() + "?" + string : this.zzgI().zzie() + this.zzgI().zzif() + "?" + string;
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzja() {
        String string = this.zzgI().zzid() + this.zzgI().zzig();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    String zza(zzaa zzaa2, boolean bl) {
        zzv.zzr((Object)zzaa2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzaa2.zzhe().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                this.zza(stringBuilder, string, entry.getValue());
            }
            this.zza(stringBuilder, "ht", String.valueOf(zzaa2.zziP()));
            long l = this.zzgG().currentTimeMillis() - zzaa2.zziP();
            this.zza(stringBuilder, "qt", String.valueOf(l));
            if (this.zzgI().zzhP()) {
                this.zza(stringBuilder, "_gmsv", this.zzfZ().zzgy());
            }
            if (bl) {
                long l2 = zzaa2.zziS();
                String string = l2 != 0L ? String.valueOf(l2) : this.zzi(zzaa2);
                this.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    private String zzi(zzaa zzaa2) {
        return String.valueOf(zzaa2.zziO());
    }

    private class zza {
        private int zzIx;
        private ByteArrayOutputStream zzIy = new ByteArrayOutputStream();

        public boolean zzj(zzaa zzaa2) {
            zzv.zzr((Object)zzaa2);
            if (this.zzIx + 1 > zzag.this.zzgI().zzib()) {
                return false;
            }
            String string = zzag.this.zza(zzaa2, false);
            if (string == null) {
                zzag.this.zzgH().zza(zzaa2, "Error formatting hit");
                return true;
            }
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            if (n > zzag.this.zzgI().zzhT()) {
                zzag.this.zzgH().zza(zzaa2, "Hit size exceeds the maximum size limit");
                return true;
            }
            if (this.zzIy.size() > 0) {
                ++n;
            }
            if (this.zzIy.size() + n > zzag.this.zzgI().zzhV()) {
                return false;
            }
            try {
                if (this.zzIy.size() > 0) {
                    this.zzIy.write(zzIw);
                }
                this.zzIy.write(byArray);
            }
            catch (IOException iOException) {
                zzag.this.zze("Failed to write payload when batching hits", iOException);
                return true;
            }
            ++this.zzIx;
            return true;
        }

        public int zzjc() {
            return this.zzIx;
        }

        public byte[] getPayload() {
            return this.zzIy.toByteArray();
        }
    }
}

