/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzaa;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.common.internal.zzv;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

class zzi
extends zzd
implements Closeable {
    private static final String zzGk = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzGl = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zza zzGm;
    private final zzai zzGn = new zzai(this.zzgG());
    private final zzai zzGo = new zzai(this.zzgG());

    zzi(zze zze2) {
        super(zze2);
        String string = this.zzho();
        this.zzGm = new zza(zze2.getContext(), string);
    }

    @Override
    protected void zzgb() {
    }

    public void beginTransaction() {
        this.zzgR();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zzgR();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zzgR();
        this.getWritableDatabase().endTransaction();
    }

    public void zzhj() {
        this.zzgF();
        this.zzgR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("hits2", null, null);
    }

    public void zzhk() {
        this.zzgF();
        this.zzgR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("properties", null, null);
    }

    public void zzc(zzaa zzaa2) {
        zzv.zzr((Object)zzaa2);
        this.zzgF();
        this.zzgR();
        String string = zzi.zze(zzaa2);
        if (string.length() > 8192) {
            this.zzgH().zza(zzaa2, "Hit length exceeds the maximum allowed size");
            return;
        }
        this.zzhn();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string);
        contentValues.put("hit_time", Long.valueOf(zzaa2.zziP()));
        contentValues.put("hit_app_id", Integer.valueOf(zzaa2.zziN()));
        contentValues.put("hit_url", this.zzd(zzaa2));
        try {
            long l = sQLiteDatabase.insert("hits2", null, contentValues);
            if (l == -1L) {
                this.zzaJ("Failed to insert a hit (got -1)");
            } else {
                this.zzb("Hit saved to database. db-id, hit", l, zzaa2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
        }
    }

    public long zzhd() {
        this.zzgF();
        this.zzgR();
        long l = this.zza("SELECT COUNT(*) FROM hits2", null);
        return l;
    }

    boolean isEmpty() {
        return this.zzhd() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> zzm(long l) {
        this.zzgF();
        this.zzgR();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public List<zzaa> zzn(long l) {
        zzv.zzQ((l >= 0L ? 1 : 0) != 0);
        this.zzgF();
        this.zzgR();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzaa> arrayList = new ArrayList<zzaa>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzaK(string);
                    boolean bl = zzal.zzaZ(string2);
                    arrayList.add(new zzaa(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzaa> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zze(List<Long> list) {
        Long l;
        zzv.zzr(list);
        this.zzgF();
        this.zzgR();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public void zzo(long l) {
        this.zzgF();
        this.zzgR();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zze(arrayList);
    }

    public int zzhl() {
        this.zzgF();
        this.zzgR();
        if (!this.zzGn.zzt(86400000L)) {
            return 0;
        }
        this.zzGn.start();
        this.zzaF("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zzgG().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public long zzhm() {
        this.zzgF();
        this.zzgR();
        return this.zza(zzGl, null, 0L);
    }

    public void zza(long l, String string) {
        zzv.zzbS((String)string);
        this.zzgR();
        this.zzgF();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l), string});
        if (n > 0) {
            this.zza("Deleted property records", n);
        }
    }

    public void zzb(zzg zzg2) {
        zzv.zzr((Object)zzg2);
        this.zzgR();
        this.zzgF();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String string = zzi.zzz(zzg2.zzhe());
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_uid", Long.valueOf(zzg2.zzha()));
        contentValues.put("cid", zzg2.getClientId());
        contentValues.put("tid", zzg2.zzhb());
        contentValues.put("adid", Integer.valueOf(zzg2.zzhc() ? 1 : 0));
        contentValues.put("hits_count", Long.valueOf(zzg2.zzhd()));
        contentValues.put("params", string);
        try {
            long l = sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5);
            if (l == -1L) {
                this.zzaJ("Failed to insert/update a property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a property", (Object)sQLiteException);
        }
    }

    public long zza(long l, String string, String string2) {
        zzv.zzbS((String)string);
        zzv.zzbS((String)string2);
        this.zzgR();
        this.zzgF();
        long l2 = this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
        return l2;
    }

    public List<zzg> zzp(long l) {
        this.zzgR();
        this.zzgF();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = this.zzgI().zzio();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{String.valueOf(l)};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzg> arrayList = new ArrayList<zzg>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzaL(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzg zzg2 = new zzg(l, (String)object, string3, bl, l2, map);
                    arrayList.add(zzg2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzaI("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public void close() {
        try {
            this.zzGm.close();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
        }
    }

    private String zzd(zzaa zzaa2) {
        if (zzaa2.zziR()) {
            return this.zzgI().zzid();
        }
        return this.zzgI().zzie();
    }

    private long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l3;
        }
    }

    private void zzhn() {
        int n = this.zzgI().zzin();
        long l = this.zzhd();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = this.zzm(l2);
            this.zzd("Store full, deleting hits to make room, count", list.size());
            this.zze(list);
        }
    }

    private static String zze(zzaa zzaa2) {
        zzv.zzr((Object)zzaa2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : zzaa2.zzhe().entrySet()) {
            String string = object2.getKey();
            if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string)) continue;
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String zzz(Map<String, String> map) {
        zzv.zzr(map);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string = object2.getKey();
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    Map<String, String> zzaK(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = string.startsWith("?") ? string : "?" + string;
            List list = URLEncodedUtils.parse((URI)new URI(string2), (String)"UTF-8");
            HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
            for (NameValuePair nameValuePair : list) {
                hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
            }
            return hashMap;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    Map<String, String> zzaL(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = "?" + string;
            List list = URLEncodedUtils.parse((URI)new URI(string2), (String)"UTF-8");
            HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
            for (NameValuePair nameValuePair : list) {
                hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
            }
            return hashMap;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzGm.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zzho() {
        if (!this.zzgI().zzhP()) {
            return this.zzgI().zzip();
        }
        if (this.zzgI().zzhQ()) {
            return this.zzgI().zzip();
        }
        return this.zzgI().zziq();
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzi.this.zzGo.zzt(3600000L)) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzi.this.zzGo.start();
                zzi.this.zzaJ("Opening the database failed, dropping the table and recreating it");
                String string = zzi.this.zzho();
                zzi.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzi.this.zzGo.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzi.this.zze("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = "SELECT * FROM " + string + " LIMIT 0";
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "hits2");
            for (String string : stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"}) {
                if (set.remove(string)) continue;
                throw new SQLiteException("Database hits2 is missing required column: " + string);
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase.execSQL(string);
            }
        }

        private void zzb(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "properties");
            for (String string : stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"}) {
                if (set.remove(string)) continue;
                throw new SQLiteException("Database properties is missing required column: " + string);
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database properties table has extra columns");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = database.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza(database, "hits2")) {
                database.execSQL(zzGk);
            } else {
                this.zza(database);
            }
            if (!this.zza(database, "properties")) {
                database.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            } else {
                this.zzb(database);
            }
        }

        public void onCreate(SQLiteDatabase database) {
            zzw.zzaQ(database.getPath());
        }

        public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        }
    }
}

